/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.bertlv;

import io.mpos.specs.bertlv.ConstructedTlv;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.emv.TagCvmCapabilityCvmRequired;
import io.mpos.specs.emv.TagCvmCapabilityNoCvmRequired;
import io.mpos.specs.helper.TagHierarchyHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TLVHelper {
    public static final List<byte[]> GLOBALLY_RETAINED_TAGS = Arrays.asList(TagCvmCapabilityCvmRequired.TAG_BYTES, TagCvmCapabilityNoCvmRequired.TAG_BYTES);

    @Nullable
    public static TlvObject[] deserializeFlatTlvObjects(byte[] tlv) {
        if (tlv == null) {
            return null;
        }
        return TLVHelper.deserializeTlvObjects(tlv).toArray(new TlvObject[0]);
    }

    @NotNull
    public static List<TlvObject> deserializeTlvObjects(byte[] tlv) {
        TlvObject tlvObject;
        LinkedList<TlvObject> linkedList = new LinkedList<TlvObject>();
        if (tlv == null) {
            return linkedList;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(tlv);
        while ((tlvObject = TlvObject.deserialize(byteBuffer)) != null) {
            linkedList.add(tlvObject);
            if (byteBuffer.remaining() > 0) continue;
        }
        return linkedList;
    }

    @Nullable
    public static byte[] serializeFlatTlvObjects(TlvObject[] tlv) {
        if (tlv == null || tlv.length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (TlvObject tlvObject : tlv) {
            byte[] byArray = tlvObject.serialize();
            try {
                byteArrayOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Nullable
    public static TlvObject findFirstItemInArray(byte[] tagBytes, TlvObject[] tlv) {
        if (tlv == null) {
            return null;
        }
        for (TlvObject tlvObject : tlv) {
            TlvObject tlvObject2;
            if (TagHierarchyHelper.doesMatch(tagBytes, tlvObject)) {
                return tlvObject;
            }
            if (tlvObject.isPrimitive() || !tlvObject.isConstructed() || (tlvObject2 = TLVHelper.findFirstInternal(tagBytes, tlvObject)) == null) continue;
            return tlvObject;
        }
        return null;
    }

    @Nullable
    public static PrimitiveTlv findFirstPrimitiveItemInArray(byte[] tagBytes, List<TlvObject> tlv) {
        return TLVHelper.findFirstPrimitiveItemInArray(tagBytes, tlv.toArray(new TlvObject[tlv.size()]));
    }

    @Nullable
    public static PrimitiveTlv findFirstPrimitiveItemInArray(byte[] tagBytes, TlvObject[] tlv) {
        if (tlv == null) {
            return null;
        }
        for (TlvObject tlvObject : tlv) {
            if (tlvObject.isPrimitive()) {
                if (!TagHierarchyHelper.doesMatch(tagBytes, tlvObject)) continue;
                return (PrimitiveTlv)tlvObject;
            }
            if (!tlvObject.isConstructed()) continue;
            if (TagHierarchyHelper.doesMatch(tagBytes, tlvObject)) {
                return null;
            }
            TlvObject tlvObject2 = TLVHelper.findFirstInternal(tagBytes, tlvObject);
            if (tlvObject2 == null || !tlvObject2.isPrimitive()) continue;
            return (PrimitiveTlv)tlvObject2;
        }
        return null;
    }

    @Nullable
    private static TlvObject findFirstInternal(byte[] tagBytes, TlvObject tlv) {
        if (tlv == null) {
            return null;
        }
        if (tagBytes == null) {
            return null;
        }
        if (TagHierarchyHelper.doesMatch(tagBytes, tlv)) {
            return tlv;
        }
        if (tlv instanceof ConstructedTlv) {
            for (TlvObject tlvObject : ((ConstructedTlv)tlv).getItems()) {
                TlvObject tlvObject2 = TLVHelper.findFirstInternal(tagBytes, tlvObject);
                if (tlvObject2 == null) continue;
                return tlvObject2;
            }
        }
        return null;
    }

    @NotNull
    public static String prettyPrint(TlvObject[] tlvs) {
        StringBuilder stringBuilder = new StringBuilder();
        TLVHelper.internalPrettyPrint(stringBuilder, tlvs);
        return stringBuilder.toString();
    }

    public static void internalPrettyPrint(StringBuilder sb, TlvObject[] tlvs) {
        if (tlvs == null) {
            sb.append("<null>");
            return;
        }
        if (tlvs.length == 0) {
            sb.append("<empty>");
            return;
        }
        sb.append('{');
        for (int i2 = 0; i2 < tlvs.length; ++i2) {
            TlvObject tlvObject = tlvs[i2];
            if (i2 > 0) {
                sb.append(", ");
            }
            if (tlvObject instanceof PrimitiveTlv) {
                sb.append(tlvObject.toString());
            }
            if (!(tlvObject instanceof ConstructedTlv)) continue;
            sb.append(tlvObject.toString());
        }
        sb.append('}');
    }

    public static boolean isTlvNotNullAndContainsValue(PrimitiveTlv tlv) {
        if (tlv == null) {
            return false;
        }
        if (tlv.getValue() == null) {
            return false;
        }
        return tlv.getValue().length != 0;
    }

    @NotNull
    private static TlvObject[] stripAllTagsWithClass(TlvObject[] source, byte tagClass) {
        ArrayList<TlvObject> arrayList = new ArrayList<TlvObject>();
        for (TlvObject tlvObject : source) {
            if (tlvObject.getCla() == tagClass) continue;
            arrayList.add(tlvObject);
        }
        return arrayList.toArray(new TlvObject[0]);
    }

    @NotNull
    public static TlvObject[] stripAllPrivateTags(TlvObject[] source) {
        return TLVHelper.stripPrivateTagsAndRetainProvided(source, Collections.emptyList());
    }

    @NotNull
    public static TlvObject[] stripAllPrivateTags(List<TlvObject> source) {
        return TLVHelper.stripAllPrivateTags(source.toArray(new TlvObject[0]));
    }

    @NotNull
    public static TlvObject[] stripPrivateTagsAndRetainProvided(TlvObject[] source, List<byte[]> retainTags) {
        TlvObject[] tlvObjectArray = TLVHelper.stripAllTagsWithClass(source, (byte)3);
        ArrayList<TlvObject> arrayList = new ArrayList<TlvObject>(Arrays.asList(tlvObjectArray));
        HashSet<byte[]> hashSet = new HashSet<byte[]>(retainTags);
        hashSet.addAll(GLOBALLY_RETAINED_TAGS);
        for (byte[] byArray : hashSet) {
            TlvObject tlvObject = TLVHelper.findFirstItemInArray(byArray, source);
            if (tlvObject == null) continue;
            arrayList.add(tlvObject);
        }
        return arrayList.toArray(new TlvObject[0]);
    }

    @NotNull
    public static TlvObject[] getExtendedWithTlvObject(TlvObject[] source, TlvObject toAdd) {
        TlvObject[] tlvObjectArray = new TlvObject[source.length + 1];
        System.arraycopy(source, 0, tlvObjectArray, 0, source.length);
        tlvObjectArray[tlvObjectArray.length - 1] = toAdd;
        return tlvObjectArray;
    }
}

