/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.bertlv;

import io.mpos.specs.bertlv.ConstructedTlv;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.helper.ByteHelper;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class TlvObject {
    public static final byte CLASS_BITS_UNIVERSAL = 0;
    public static final byte CLASS_BITS_APPLICATION = 1;
    public static final byte CLASS_BITS_CONTEXT_SPECIFIC = 2;
    public static final byte CLASS_BITS_PRIVATE = 3;
    private static final byte MASK_TAG_CLA_BITS = -64;
    private static final byte MASK_TAG_TYPE_CONSTRUCTED = 32;
    private static final byte MASK_TAG_NUMBER = 31;
    private static final byte MASK_TAG_NEXT = -128;
    private static final byte MASK_TAG_NEXT_VAL = 127;
    private static final byte MASK_LEN_INDICATOR_GREATER_127 = -128;
    private static final byte MASK_LEN_VALUE_LOWER_THAN_127 = 127;
    byte[] tagBytes = null;
    protected byte[] cacheSerialization = null;

    public abstract byte[] serialize();

    public static TlvObject deserialize(byte[] raw) {
        if (raw == null) {
            throw new IllegalArgumentException("The raw buffer must not be null.");
        }
        if (raw.length == 0) {
            throw new IllegalArgumentException("The raw buffer must have a length > 0.");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(raw);
        return TlvObject.deserialize(byteBuffer);
    }

    public static TlvObject deserialize(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return null;
        }
        byte by2 = buffer.get();
        while (by2 == 0 && buffer.hasRemaining()) {
            by2 = buffer.get();
        }
        if (!buffer.hasRemaining()) {
            return null;
        }
        boolean bl2 = (by2 & 0x20) == 0;
        byte[] byArray = TlvObject.parseTagBytes(by2, buffer);
        int n2 = TlvObject.parseLen(buffer);
        if (n2 > buffer.remaining()) {
            throw new IllegalStateException("The parsed length of " + n2 + " (= 0x" + ByteHelper.toHexString(n2) + ") is greater than the remaining buffer length of " + buffer.remaining() + ".");
        }
        if (bl2) {
            return PrimitiveTlv.deserialize(byArray, n2, buffer);
        }
        return ConstructedTlv.deserialize(byArray, n2, buffer);
    }

    private static byte[] parseTagBytes(byte firstByte, ByteBuffer buffer) {
        int n2;
        boolean bl2;
        boolean bl3 = bl2 = (firstByte & 0x1F) == 31;
        if (!bl2) {
            return new byte[]{firstByte};
        }
        int n3 = buffer.position() - 1;
        while (((n2 = buffer.get()) & 0xFFFFFF80) != 0) {
        }
        n2 = buffer.position();
        int n4 = n2 - n3;
        byte[] byArray = new byte[n4];
        System.arraycopy(buffer.array(), n3, byArray, 0, n4);
        return byArray;
    }

    private static int parseLen(ByteBuffer buffer) {
        boolean bl2;
        byte by2 = buffer.get();
        boolean bl3 = bl2 = (by2 & 0xFFFFFF80) == -128;
        if (!bl2) {
            return by2 & 0x7F;
        }
        int n2 = by2 & 0x7F;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 << 8 & 0xFFFFFF00;
            n3 |= buffer.get() & 0xFF;
        }
        if (n3 < 0) {
            throw new IllegalStateException("The parsed length should never be smaller than 0: " + ByteHelper.toHexString(n3));
        }
        return n3;
    }

    private static int parseTagNumber(byte firstByte, ByteBuffer buffer) {
        byte by2;
        boolean bl2;
        boolean bl3 = bl2 = (firstByte & 0x1F) == 31;
        if (!bl2) {
            return firstByte & 0x1F;
        }
        int n2 = 0;
        do {
            by2 = buffer.get();
            n2 = n2 << 7 & 0xFFFFFF80;
            n2 |= by2 & 0x7F;
        } while ((by2 & 0xFFFFFF80) != 0);
        return n2;
    }

    byte[] buildTagBytes(byte cla, int tag) {
        byte[] byArray;
        byte by2 = 0;
        by2 = (byte)(by2 | cla << 6 & 0xFF & 0xFFFFFFC0);
        if (this.isConstructed()) {
            by2 = (byte)(by2 | 0x20);
        }
        if (tag < 31) {
            by2 = (byte)(by2 | tag & 0x1F);
            byArray = new byte[]{by2};
        } else {
            by2 = (byte)(by2 | 0x1F);
            byte[] byArray2 = new byte[5];
            int n2 = 0;
            while (tag != 0) {
                byArray2[n2] = (byte)(tag & 0x7F);
                tag = tag >> 7 & 0x1FFFFFF;
                n2 = (byte)(n2 + 1);
            }
            byArray = new byte[n2 + 1];
            byArray[0] = by2;
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2 + 1] = byArray2[n2 - i2 - 1];
                if (i2 >= n2 - 1) continue;
                int n3 = i2 + 1;
                byArray[n3] = (byte)(byArray[n3] | 0xFFFFFF80);
            }
        }
        return byArray;
    }

    byte[] buildLenBytes(int length) {
        byte[] byArray;
        if (length <= 127) {
            byArray = new byte[]{(byte)(length & 0x7F)};
        } else {
            byte[] byArray2 = new byte[4];
            int n2 = 0;
            while (length != 0) {
                byArray2[n2] = (byte)(length & 0xFF);
                length = length >> 8 & 0xFFFFFF;
                ++n2;
            }
            byArray = new byte[n2 + 1];
            byArray[0] = (byte)(n2 & 0x7F);
            byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2 + 1] = byArray2[n2 - i2 - 1];
            }
        }
        return byArray;
    }

    public byte[] getTagBytes() {
        return this.tagBytes;
    }

    public boolean hasThisTag(byte[] compare) {
        if (compare == null) {
            throw new IllegalArgumentException("'compare' must not be null.");
        }
        return Arrays.equals(this.getTagBytes(), compare);
    }

    public int getTag() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.tagBytes);
        byte by2 = byteBuffer.get();
        return TlvObject.parseTagNumber(by2, byteBuffer);
    }

    public byte getCla() {
        byte by2 = this.tagBytes[0];
        return (byte)((by2 & 0xFFFFFFC0) >> 6 & 3);
    }

    protected abstract int getLen();

    public boolean isPrimitive() {
        return this instanceof PrimitiveTlv;
    }

    public boolean isConstructed() {
        return this instanceof ConstructedTlv;
    }

    public boolean hasCachedSerialization() {
        return this.cacheSerialization != null;
    }

    public String toString() {
        return "TlvObject{tagBytes=" + ByteHelper.toHexString(this.getTagBytes()) + (String)(this.cacheSerialization != null ? ", cacheSerialization=" + ByteHelper.toHexString(this.cacheSerialization) : "") + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        TlvObject tlvObject = (TlvObject)o2;
        if (!Arrays.equals(this.cacheSerialization, tlvObject.cacheSerialization)) {
            return false;
        }
        return Arrays.equals(this.tagBytes, tlvObject.tagBytes);
    }

    public int hashCode() {
        int n2 = this.tagBytes != null ? Arrays.hashCode(this.tagBytes) : 0;
        n2 = 31 * n2 + (this.cacheSerialization != null ? Arrays.hashCode(this.cacheSerialization) : 0);
        return n2;
    }
}

