/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedBinaryTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagApplicationIdentifier
extends MappedBinaryTlv {
    public static int TAG = 40710;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int MIN_LENGTH = 5;
    public static int MAX_LENGTH = 16;

    private TagApplicationIdentifier(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Identifies the application as described in ISO/IEC 7816-5";
    }

    public static TagApplicationIdentifier create(byte[] aid) {
        if (aid.length < MIN_LENGTH) {
            throw new IllegalArgumentException("The AID must be at least 5 bytes long.");
        }
        if (aid.length > MAX_LENGTH) {
            throw new IllegalArgumentException("The AID must not be longer than 16 bytes.");
        }
        return new TagApplicationIdentifier(aid);
    }

    public static TagApplicationIdentifier wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagApplicationIdentifier.create(tlv.getValue());
    }
}

