/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedAlphaNumericISOLatin1Tlv;
import io.mpos.specs.helper.ByteHelper;

public class TagApplicationLabelISOLatin1
extends MappedAlphaNumericISOLatin1Tlv {
    public static int TAG = 80;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int MIN_LENGTH = 1;
    public static int MAX_LENGTH = 16;

    private TagApplicationLabelISOLatin1(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Mnemonic associated with the AID according to ISO/IEC 7816-5";
    }

    public static TagApplicationLabelISOLatin1 create(byte[] aid) {
        if (aid.length < MIN_LENGTH) {
            throw new IllegalArgumentException("The AID must be at least 1 bytes long.");
        }
        if (aid.length > MAX_LENGTH) {
            throw new IllegalArgumentException("The AID must not be longer than 16 bytes.");
        }
        return new TagApplicationLabelISOLatin1(aid);
    }

    public static TagApplicationLabelISOLatin1 wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagApplicationLabelISOLatin1.create(tlv.getValue());
    }
}

