/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;

public class TagApplicationPrimaryAccountNumberSequenceNumber
extends MappedNumericTlv {
    public static int TAG = 24372;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int FIXED_LENGTH = 1;

    private TagApplicationPrimaryAccountNumberSequenceNumber(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Identifies and differentiates cards with the same PAN";
    }

    public static TagApplicationPrimaryAccountNumberSequenceNumber create(String cardSequenceNumber) {
        cardSequenceNumber = EnDecodeHelper.removeAllExceptNumeric(cardSequenceNumber);
        byte[] byArray = MappedNumericTlv.encodeValueFixedLength(cardSequenceNumber, FIXED_LENGTH);
        return new TagApplicationPrimaryAccountNumberSequenceNumber(byArray);
    }

    public static TagApplicationPrimaryAccountNumberSequenceNumber wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (tlv.getValue().length != FIXED_LENGTH) {
            throw new IllegalArgumentException("The value must have a length of: " + FIXED_LENGTH);
        }
        return new TagApplicationPrimaryAccountNumberSequenceNumber(tlv.getValue());
    }
}

