/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedAlphanumericTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagAuthorisationResponseCode
extends MappedAlphanumericTlv {
    public static int TAG = 138;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int FIXED_LENGTH = 2;

    private TagAuthorisationResponseCode(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Code that defines the disposition of a message";
    }

    public static TagAuthorisationResponseCode create(byte[] respCode) {
        return new TagAuthorisationResponseCode(respCode);
    }

    public static TagAuthorisationResponseCode wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagAuthorisationResponseCode.create(tlv.getValue());
    }
}

