/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedAlphanumericSpecialTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagCardholderName
extends MappedAlphanumericSpecialTlv {
    public static int TAG = 24352;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int MIN_LENGTH = 2;
    public static int MAX_LENGTH = 26;

    private TagCardholderName(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Indicates cardholder name according to ISO 7813";
    }

    public static TagCardholderName create(byte[] name) {
        if (name.length < MIN_LENGTH) {
            throw new IllegalArgumentException("The name must be at least " + MIN_LENGTH + " bytes long. (" + name.length + ")");
        }
        if (name.length > MAX_LENGTH) {
            throw new IllegalArgumentException("The name must not be longer than " + MAX_LENGTH + " bytes. (" + name.length + ")");
        }
        return new TagCardholderName(name);
    }

    public static TagCardholderName wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagCardholderName.create(tlv.getValue());
    }
}

