/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagCryptogramInformationData
extends MappedNumericTlv {
    public static final int TAG = 40743;
    public static final byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(40743);
    public static final int FIXED_LENGTH = 1;

    private TagCryptogramInformationData(byte[] bytes) {
        super(TAG_BYTES, bytes);
    }

    @Override
    public String getDescription() {
        return "The result of a cryptogram generation";
    }

    public static TagCryptogramInformationData wrap(PrimitiveTlv primitiveTlv) {
        if (!primitiveTlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (primitiveTlv.getValue().length != 1) {
            throw new IllegalArgumentException("The value must have a length of: 1");
        }
        return new TagCryptogramInformationData(primitiveTlv.getValue());
    }
}

