/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedBinaryTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagDiscoverContactlessCardVerificationResults
extends MappedBinaryTlv {
    public static int TAG = 40787;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int LENGTH = 8;
    public static final byte CCVR_3RD_BYTE_INVERSE_NOCVM_FLAG = -128;

    private TagDiscoverContactlessCardVerificationResults(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Discover Contactless Card Verification Results tag";
    }

    public static TagDiscoverContactlessCardVerificationResults create(byte[] cvm) {
        if (cvm.length != LENGTH) {
            throw new IllegalArgumentException("The results must be exactly 8 bytes long.");
        }
        return new TagDiscoverContactlessCardVerificationResults(cvm);
    }

    public static TagDiscoverContactlessCardVerificationResults wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagDiscoverContactlessCardVerificationResults.create(tlv.getValue());
    }

    public boolean indicatesNoCvm() {
        byte by2 = this.getValue()[2];
        return (by2 & 0xFFFFFF80) != -128;
    }
}

