/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedBinaryTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagIssuerAuthenticationData
extends MappedBinaryTlv {
    public static int TAG = 145;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int MIN_LENGTH = 8;
    public static int MAX_LENGTH = 16;

    private TagIssuerAuthenticationData(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Data sent to the ICC for online issuer authentication";
    }

    public static TagIssuerAuthenticationData create(byte[] authData) {
        if (authData.length > MAX_LENGTH) {
            throw new IllegalArgumentException("The authData must not be longer than 16 bytes.");
        }
        return new TagIssuerAuthenticationData(authData);
    }

    public static TagIssuerAuthenticationData wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagIssuerAuthenticationData.create(tlv.getValue());
    }
}

