/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedAlphanumericTlv;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;

public class TagTerminalIdentification
extends MappedAlphanumericTlv {
    public static int TAG = 40732;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);

    private TagTerminalIdentification(byte[] terminalId) {
        super(TAG_BYTES, terminalId);
    }

    @Override
    public String getDescription() {
        return "Designates the unique location of a terminal at a merchant";
    }

    public static TagTerminalIdentification create(String terminalId) {
        byte[] terminalIdData;
        if (terminalId != null) {
            if (((String)terminalId).length() > 8) {
                terminalId = ((String)terminalId).substring(((String)terminalId).length() - 8, 8);
            } else if (((String)terminalId).length() < 8) {
                int n2 = 8 - ((String)terminalId).length();
                String string = "00000000".substring(8 - n2);
                terminalId = string + (String)terminalId;
            }
            terminalIdData = EnDecodeHelper.toAscii((String)terminalId);
        } else {
            terminalIdData = EnDecodeHelper.toAscii("00000000");
        }
        return new TagTerminalIdentification(terminalIdData);
    }

    public static TagTerminalIdentification wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of=" + ByteHelper.toHexString(TAG_BYTES));
        }
        return new TagTerminalIdentification(tlv.getValue());
    }
}

