/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedBinaryTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagTerminalVerificationResults
extends MappedBinaryTlv {
    public static int TAG = 149;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int FIXED_LENGTH = 5;

    private TagTerminalVerificationResults(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Status of the different functions as seen from the terminal";
    }

    public static TagTerminalVerificationResults create(byte[] value) {
        if (value.length != FIXED_LENGTH) {
            throw new IllegalArgumentException("The value must have a length of: " + FIXED_LENGTH);
        }
        return new TagTerminalVerificationResults(value);
    }

    public static TagTerminalVerificationResults wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagTerminalVerificationResults.create(tlv.getValue());
    }
}

