/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagTransactionSequenceCounter
extends MappedNumericTlv {
    public static int TAG = 40769;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int MIN_LENGTH = 2;
    public static int MAX_LENGTH = 4;

    private TagTransactionSequenceCounter(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Counter maintained by the terminal that is incremented by one for each transaction";
    }

    private static TagTransactionSequenceCounter create(byte[] counterValue) {
        if (counterValue.length < MIN_LENGTH) {
            throw new IllegalArgumentException("The counterValue must be at least 2 bytes long.");
        }
        if (counterValue.length > MAX_LENGTH) {
            throw new IllegalArgumentException("The counterValue must not be longer than 4 bytes.");
        }
        return new TagTransactionSequenceCounter(counterValue);
    }

    public static TagTransactionSequenceCounter create(Integer counterValue) {
        byte[] byArray = ByteHelper.intToBCD(counterValue, 4);
        return new TagTransactionSequenceCounter(byArray);
    }

    public static TagTransactionSequenceCounter wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagTransactionSequenceCounter.create(tlv.getValue());
    }

    public long getSequenceCounterValue() {
        return this.decodeValue();
    }
}

