/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;

public class TagTransactionType
extends MappedNumericTlv {
    public static int TAG = 156;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int FIXED_LENGTH_BYTES = 1;
    public static int FIXED_LENGTH_DIGITS = 2;
    public static final String TYPE_PURCHASE = "00";
    public static final String TYPE_REFUND = "20";

    private TagTransactionType(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Indicates the type of financial transaction, represented by the first two digits of the ISO 8583:1987 Processing Code. The actual values to be used for the Transaction Type data element are defined by the relevant payment system";
    }

    public static TagTransactionType create(String transactionType) {
        if (transactionType.length() > FIXED_LENGTH_DIGITS) {
            throw new IllegalArgumentException("Only two digits allowed in transactionType");
        }
        byte[] byArray = MappedNumericTlv.encodeValueFixedLength(transactionType, FIXED_LENGTH_BYTES);
        return new TagTransactionType(byArray);
    }

    public static TagTransactionType wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (tlv.getValue().length != FIXED_LENGTH_BYTES) {
            throw new IllegalArgumentException("The value must have a length of: " + FIXED_LENGTH_BYTES);
        }
        return new TagTransactionType(tlv.getValue());
    }

    public boolean isPurchase() {
        return EnDecodeHelper.fromHex(this.getValue()).equals(TYPE_PURCHASE);
    }

    public boolean isRefund() {
        return EnDecodeHelper.fromHex(this.getValue()).equals(TYPE_REFUND);
    }
}

