/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.shared.paymentdetails.PaymentDetailsCustomerVerificationDetailed;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedBinaryTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagVisaCardTransactionQualifiers
extends MappedBinaryTlv {
    public static int TAG = 40812;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int LENGTH = 2;
    public static final int CTQ_1ST_BYTE_ONLINE_PIN_FLAG = 128;
    public static final int CTQ_1ST_BYTE_SIGNATURE_FLAG = 64;
    public static final int CTQ_2ND_BYTE_ODCVM_FLAG = 128;

    private TagVisaCardTransactionQualifiers(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Visa Card Transaction Qualifiers (TTQ) tag";
    }

    public static TagVisaCardTransactionQualifiers create(byte[] cvm) {
        if (cvm.length != LENGTH) {
            throw new IllegalArgumentException("The qualifiers must be exactly 2 bytes long.");
        }
        return new TagVisaCardTransactionQualifiers(cvm);
    }

    public static TagVisaCardTransactionQualifiers wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagVisaCardTransactionQualifiers.create(tlv.getValue());
    }

    public PaymentDetailsCustomerVerificationDetailed getCvm() {
        byte by2 = this.getValue()[0];
        byte by3 = this.getValue()[1];
        if ((by2 & 0x80) == 128) {
            return PaymentDetailsCustomerVerificationDetailed.PIN_ONLINE;
        }
        if ((by2 & 0x40) == 64) {
            return PaymentDetailsCustomerVerificationDetailed.SIGNATURE;
        }
        if ((by3 & 0x80) == 128) {
            return PaymentDetailsCustomerVerificationDetailed.CUSTOMER_DEVICE;
        }
        return PaymentDetailsCustomerVerificationDetailed.NONE;
    }
}

