/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.helper;

import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ByteHelper {
    private static final String[] HEX = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};
    private static final Pattern REGEX_NOT_HEX = Pattern.compile("[^a-fA-F0-9]");

    public static byte[] intToStrippedByteArray(int i2) {
        if (i2 == 0) {
            return new byte[0];
        }
        byte by2 = (byte)(i2 & 0xFF);
        byte by3 = (byte)(i2 >> 8 & 0xFF);
        if (i2 > 65535) {
            byte by4 = (byte)(i2 >> 16 & 0xFF);
            byte by5 = (byte)(i2 >> 24 & 0xFF);
            if (i2 > 0xFFFFFF) {
                return new byte[]{by5, by4, by3, by2};
            }
            return new byte[]{by4, by3, by2};
        }
        if (i2 > 255) {
            return new byte[]{by3, by2};
        }
        return new byte[]{by2};
    }

    public static byte[] intTo32BitArray(int i2) {
        byte by2 = (byte)(i2 & 0xFF);
        byte by3 = (byte)(i2 >> 8 & 0xFF);
        byte by4 = (byte)(i2 >> 16 & 0xFF);
        byte by5 = (byte)(i2 >> 24 & 0xFF);
        return new byte[]{by5, by4, by3, by2};
    }

    public static byte[] intTo24BitArray(int i2) {
        if (i2 > 0xFFFFFF) {
            throw new IllegalArgumentException("The given number of " + ByteHelper.toHexString(i2) + " is greater than 0x00FFFFFF");
        }
        byte by2 = (byte)(i2 & 0xFF);
        byte by3 = (byte)(i2 >> 8 & 0xFF);
        byte by4 = (byte)(i2 >> 16 & 0xFF);
        return new byte[]{by4, by3, by2};
    }

    public static String toHexString(byte b2) {
        int n2 = b2 >= 0 ? b2 : b2 + 256;
        return HEX[n2];
    }

    public static String toHexString(byte ... arr) {
        if (arr == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < arr.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(ByteHelper.toHexString(arr[i2]));
        }
        return stringBuilder.toString();
    }

    public static String toHexShortString(byte[] arr) {
        if (arr == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < arr.length; ++i2) {
            stringBuilder.append(ByteHelper.toHexString(arr[i2]));
        }
        return stringBuilder.toString();
    }

    public static String toHexString(int i2) {
        byte by2 = (byte)(i2 & 0xFF);
        byte by3 = (byte)(i2 >> 8 & 0xFF);
        byte by4 = (byte)(i2 >> 16 & 0xFF);
        byte by5 = (byte)(i2 >> 24 & 0xFF);
        return ByteHelper.toHexString(by5, by4, by3, by2);
    }

    public static byte[] fromHexString(String s2) {
        Matcher matcher = REGEX_NOT_HEX.matcher((CharSequence)s2);
        if (((String)(s2 = matcher.replaceAll(""))).length() % 2 != 0) {
            s2 = "0" + (String)s2;
        }
        int n2 = ((String)s2).length() / 2;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)Integer.parseInt(((String)s2).substring(i2 + i2, i2 + i2 + 2), 16);
        }
        return byArray;
    }

    public static int to32BitUnsignedInteger(byte[] arr) {
        if (arr == null) {
            throw new IllegalArgumentException("The array must not be null.");
        }
        if (arr.length > 4) {
            throw new IllegalArgumentException("Array is too long (" + arr.length + " elements) for 32 bit integer");
        }
        if (arr.length == 4 && arr[0] < 0) {
            throw new IllegalArgumentException("Result would be negative for " + ByteHelper.toHexString(arr));
        }
        if (arr.length == 0) {
            return 0;
        }
        int n2 = 0;
        for (byte by2 : arr) {
            n2 <<= 8;
            n2 |= ByteHelper.signedByteToUnsigned(by2);
        }
        return n2;
    }

    public static int signedByteToUnsigned(byte theByte) {
        return theByte & 0xFF;
    }

    public static byte[] append(byte[] b1, byte[] b2) {
        byte[] byArray = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, byArray, 0, b1.length);
        System.arraycopy(b2, 0, byArray, b1.length, b2.length);
        return byArray;
    }

    public static int find(byte[] source, byte[] match, int start2) {
        if (source == null || match == null) {
            return -1;
        }
        if (source.length == 0 || match.length == 0) {
            return -1;
        }
        int n2 = -1;
        int n3 = 0;
        byte by2 = match[n3];
        for (int i2 = start2; i2 < source.length; ++i2) {
            if (by2 == source[i2]) {
                if (n3 == 0) {
                    n2 = i2;
                } else if (n3 == match.length - 1) {
                    return n2;
                }
                by2 = match[++n3];
                continue;
            }
            n2 = -1;
            n3 = 0;
            by2 = match[n3];
        }
        return n2;
    }

    public static int find(byte[] source, byte data, int start2) {
        for (int i2 = start2; i2 < source.length; ++i2) {
            if (source[i2] != data) continue;
            return i2;
        }
        return -1;
    }

    public static byte[] intToBCD(Integer data, int byteSize) {
        if (data == null) {
            data = 0;
        }
        data = Math.abs(data);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMinimumIntegerDigits(byteSize * 2);
        numberFormat.setMaximumIntegerDigits(byteSize * 2);
        numberFormat.setGroupingUsed(false);
        String string = numberFormat.format(data);
        int n2 = string.length();
        byte[] byArray = new byte[n2 / 2];
        int n3 = 0;
        boolean bl2 = n2 % 2 != 0;
        for (char c2 : string.toCharArray()) {
            byte by2 = (byte)(c2 - 48);
            if (bl2) {
                int n4 = n3++;
                byArray[n4] = (byte)(byArray[n4] | by2);
            } else {
                int n5 = n3;
                byArray[n5] = (byte)(byArray[n5] | (byte)(by2 << 4));
            }
            bl2 = !bl2;
        }
        return byArray;
    }
}

