/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.helper;

import io.mpos.errors.MposRuntimeException;
import io.mpos.logger.LoggerKt;
import io.mpos.shared.transactions.CountryWrapper;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.emv.TagApplicationPreferredLanguages;
import io.mpos.specs.emv.TagIssuerCountryCode;
import io.mpos.specs.helper.TagExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\f\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/mpos/specs/helper/PreferredLanguageExtractor;", "", "<init>", "()V", "TAG", "", "extract", "", "Ljava/util/Locale;", "response", "Lio/mpos/specs/bertlv/TlvObject;", "countryCodeTag", "extractCountryAlpha2Code", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nPreferredLanguageExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreferredLanguageExtractor.kt\nio/mpos/specs/helper/PreferredLanguageExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1563#2:57\n1634#2,3:58\n*S KotlinDebug\n*F\n+ 1 PreferredLanguageExtractor.kt\nio/mpos/specs/helper/PreferredLanguageExtractor\n*L\n31#1:57\n31#1:58,3\n*E\n"})
public final class PreferredLanguageExtractor {
    @NotNull
    public static final PreferredLanguageExtractor INSTANCE = new PreferredLanguageExtractor();
    @NotNull
    public static final String TAG = "PreferredLanguageExtractor";

    private PreferredLanguageExtractor() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Locale> extract(@Nullable TlvObject response, @Nullable TlvObject countryCodeTag) {
        if (response != null) {
            String string = INSTANCE.extractCountryAlpha2Code(countryCodeTag);
            PrimitiveTlv primitiveTlv = TagExtractor.extractFirstPrimitive(TagApplicationPreferredLanguages.TAG_BYTES, response);
            if (primitiveTlv != null) {
                Iterable iterable;
                String string2 = TagApplicationPreferredLanguages.wrap(primitiveTlv).getValueAsString();
                if (string2.length() % 2 != 0) {
                    LoggerKt.logWarn$default(TAG, "TagApplicationPreferredLanguages " + string2 + " contains odd number of bytes: " + string2.length(), null, 4, null);
                }
                Intrinsics.checkNotNull((Object)string2);
                Iterable iterable2 = iterable = (Iterable)StringsKt.chunked((CharSequence)string2, (int)2);
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                for (Object t2 : iterable2) {
                    String string3 = (String)t2;
                    Collection collection2 = collection;
                    collection2.add(new Locale(string3, string));
                }
                return (List)collection;
            }
        }
        return CollectionsKt.emptyList();
    }

    public static /* synthetic */ List extract$default(TlvObject tlvObject, TlvObject tlvObject2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            tlvObject2 = null;
        }
        return PreferredLanguageExtractor.extract(tlvObject, tlvObject2);
    }

    private final String extractCountryAlpha2Code(TlvObject countryCodeTag) {
        try {
            if (countryCodeTag == null) {
                return "";
            }
            PrimitiveTlv primitiveTlv = TagExtractor.extractFirstPrimitive(TagIssuerCountryCode.TAG_BYTES, countryCodeTag);
            if (primitiveTlv == null) {
                return "";
            }
            PrimitiveTlv primitiveTlv2 = primitiveTlv;
            String string = TagIssuerCountryCode.wrap(primitiveTlv2).getValueAsString();
            int n2 = Integer.parseInt(string);
            return CountryWrapper.Companion.alpha2IsoCodeForIsoNumber(n2);
        }
        catch (NumberFormatException numberFormatException) {
            LoggerKt.logError(TAG, "Failed to get an Alpha2 country code from the tlv tag", numberFormatException);
        }
        catch (MposRuntimeException mposRuntimeException) {
            LoggerKt.logError(TAG, "Failed to get an Alpha2 country code from the tlv tag", mposRuntimeException);
        }
        return "";
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Locale> extract(@Nullable TlvObject response) {
        return PreferredLanguageExtractor.extract$default(response, null, 2, null);
    }
}

