/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.helper;

import io.mpos.specs.bertlv.ConstructedTlv;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.TlvObject;
import java.util.ArrayList;
import java.util.Arrays;

public class TagHierarchyHelper {
    public static boolean templateHasAtLeast(byte[] templateBytes, byte[][] requiredTags, TlvObject tlv) {
        if (templateBytes == null) {
            throw new IllegalArgumentException("The templateBytes array must not be null");
        }
        if (requiredTags == null) {
            throw new IllegalArgumentException("The requiredTags array must not be null");
        }
        if (tlv == null) {
            throw new IllegalArgumentException("The TLV object must not be null. Most likely, you tried to wrap a response that does not have any TLV with a class that requires at least one.");
        }
        if (!(tlv instanceof ConstructedTlv)) {
            throw new IllegalArgumentException("The TLV object must be a sub class of ConstructedTlv");
        }
        ConstructedTlv constructedTlv = (ConstructedTlv)tlv;
        int n2 = 0;
        if (requiredTags.length > 0 && Arrays.equals(requiredTags[0], templateBytes)) {
            ++n2;
        }
        while (n2 < requiredTags.length) {
            boolean bl2 = false;
            for (TlvObject tlvObject : constructedTlv.getItems()) {
                if (!TagHierarchyHelper.doesMatch(requiredTags[n2], tlvObject)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isConform(byte[][] tagHierarchy, TlvObject tlv) {
        if (tagHierarchy == null || tagHierarchy.length == 0) {
            return true;
        }
        try {
            TagHierarchyHelper.checkRecursivelyOrThrowException(0, tagHierarchy, tlv);
        }
        catch (DoesNotMatchException doesNotMatchException) {
            return false;
        }
        return true;
    }

    private static int checkRecursivelyOrThrowException(int offset, byte[][] tagHierarchy, TlvObject tlv) throws DoesNotMatchException {
        if (offset >= tagHierarchy.length) {
            throw new DoesNotMatchException();
        }
        if (!TagHierarchyHelper.doesMatch(tagHierarchy[offset], tlv)) {
            throw new DoesNotMatchException();
        }
        if (tlv instanceof PrimitiveTlv) {
            return 1;
        }
        if (tlv instanceof ConstructedTlv) {
            ConstructedTlv constructedTlv = (ConstructedTlv)tlv;
            ++offset;
            int n2 = 1;
            ArrayList<TlvObject> arrayList = constructedTlv.getItems();
            for (TlvObject tlvObject : arrayList) {
                int n3 = TagHierarchyHelper.checkRecursivelyOrThrowException(offset, tagHierarchy, tlvObject);
                offset += n3;
                n2 += n3;
            }
            return n2;
        }
        throw new IllegalStateException("Found object that is neither PrimitiveTlv nor ConstructedTlv. This should not happen.");
    }

    public static boolean doesMatch(byte[] tagBytes, TlvObject tlv) {
        return Arrays.equals(tagBytes, tlv.getTagBytes());
    }

    private static class DoesNotMatchException
    extends Exception {
        private DoesNotMatchException() {
        }
    }
}

