/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.helper.cid;

import io.mpos.specs.helper.cid.ApplicationCryptogramType;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0002 !B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\rJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lio/mpos/specs/helper/cid/CryptogramInformationData;", "", "type", "Lio/mpos/specs/helper/cid/ApplicationCryptogramType;", "paymentSpecificCryptogram", "", "adviceRequired", "", "reasonCode", "Lio/mpos/specs/helper/cid/CryptogramInformationData$ReasonCode;", "<init>", "(Lio/mpos/specs/helper/cid/ApplicationCryptogramType;IZLio/mpos/specs/helper/cid/CryptogramInformationData$ReasonCode;)V", "byte", "(I)V", "getType", "()Lio/mpos/specs/helper/cid/ApplicationCryptogramType;", "getPaymentSpecificCryptogram", "()I", "getAdviceRequired", "()Z", "getReasonCode", "()Lio/mpos/specs/helper/cid/CryptogramInformationData$ReasonCode;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "ReasonCode", "Companion", "mpos.core"})
public final class CryptogramInformationData {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationCryptogramType type;
    private final int paymentSpecificCryptogram;
    private final boolean adviceRequired;
    @NotNull
    private final ReasonCode reasonCode;
    @Deprecated
    public static final int ACT_MASK = 192;
    @Deprecated
    public static final int ACT_AAC = 0;
    @Deprecated
    public static final int ACT_TC = 64;
    @Deprecated
    public static final int ACT_ARQC = 128;
    @Deprecated
    public static final int PSC_MASK = 48;
    @Deprecated
    public static final int AR_MASK = 8;
    @Deprecated
    public static final int RC_MASK = 7;
    @Deprecated
    public static final int RC_NIG = 0;
    @Deprecated
    public static final int RC_SNA = 1;
    @Deprecated
    public static final int RC_PTLE = 2;
    @Deprecated
    public static final int RC_IAF = 3;

    public CryptogramInformationData(@NotNull ApplicationCryptogramType type, int paymentSpecificCryptogram, boolean adviceRequired, @NotNull ReasonCode reasonCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)reasonCode), (String)"");
        this.type = type;
        this.paymentSpecificCryptogram = paymentSpecificCryptogram;
        this.adviceRequired = adviceRequired;
        this.reasonCode = reasonCode;
    }

    @NotNull
    public final ApplicationCryptogramType getType() {
        return this.type;
    }

    public final int getPaymentSpecificCryptogram() {
        return this.paymentSpecificCryptogram;
    }

    public final boolean getAdviceRequired() {
        return this.adviceRequired;
    }

    @NotNull
    public final ReasonCode getReasonCode() {
        return this.reasonCode;
    }

    public CryptogramInformationData(int n2) {
        this(Companion.parseACT(n2), Companion.parsePaymentSpecificCryptogram(n2), Companion.parseAdviceRequired(n2), Companion.parseReasonCode(n2));
    }

    @NotNull
    public final ApplicationCryptogramType component1() {
        return this.type;
    }

    public final int component2() {
        return this.paymentSpecificCryptogram;
    }

    public final boolean component3() {
        return this.adviceRequired;
    }

    @NotNull
    public final ReasonCode component4() {
        return this.reasonCode;
    }

    @NotNull
    public final CryptogramInformationData copy(@NotNull ApplicationCryptogramType type, int paymentSpecificCryptogram, boolean adviceRequired, @NotNull ReasonCode reasonCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)reasonCode), (String)"");
        return new CryptogramInformationData(type, paymentSpecificCryptogram, adviceRequired, reasonCode);
    }

    public static /* synthetic */ CryptogramInformationData copy$default(CryptogramInformationData cryptogramInformationData, ApplicationCryptogramType applicationCryptogramType, int n2, boolean bl2, ReasonCode reasonCode, int n3, Object object) {
        if ((n3 & 1) != 0) {
            applicationCryptogramType = cryptogramInformationData.type;
        }
        if ((n3 & 2) != 0) {
            n2 = cryptogramInformationData.paymentSpecificCryptogram;
        }
        if ((n3 & 4) != 0) {
            bl2 = cryptogramInformationData.adviceRequired;
        }
        if ((n3 & 8) != 0) {
            reasonCode = cryptogramInformationData.reasonCode;
        }
        return cryptogramInformationData.copy(applicationCryptogramType, n2, bl2, reasonCode);
    }

    @NotNull
    public String toString() {
        return "CryptogramInformationData(type=" + this.type + ", paymentSpecificCryptogram=" + this.paymentSpecificCryptogram + ", adviceRequired=" + this.adviceRequired + ", reasonCode=" + this.reasonCode + ")";
    }

    public int hashCode() {
        int n2 = this.type.hashCode();
        n2 = n2 * 31 + Integer.hashCode(this.paymentSpecificCryptogram);
        n2 = n2 * 31 + Boolean.hashCode(this.adviceRequired);
        n2 = n2 * 31 + this.reasonCode.hashCode();
        return n2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CryptogramInformationData)) {
            return false;
        }
        CryptogramInformationData cryptogramInformationData = (CryptogramInformationData)other;
        if (this.type != cryptogramInformationData.type) {
            return false;
        }
        if (this.paymentSpecificCryptogram != cryptogramInformationData.paymentSpecificCryptogram) {
            return false;
        }
        if (this.adviceRequired != cryptogramInformationData.adviceRequired) {
            return false;
        }
        return this.reasonCode == cryptogramInformationData.reasonCode;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/mpos/specs/helper/cid/CryptogramInformationData$Companion;", "", "<init>", "()V", "ACT_MASK", "", "ACT_AAC", "ACT_TC", "ACT_ARQC", "PSC_MASK", "AR_MASK", "RC_MASK", "RC_NIG", "RC_SNA", "RC_PTLE", "RC_IAF", "parseACT", "Lio/mpos/specs/helper/cid/ApplicationCryptogramType;", "byte", "parsePaymentSpecificCryptogram", "parseAdviceRequired", "", "parseReasonCode", "Lio/mpos/specs/helper/cid/CryptogramInformationData$ReasonCode;", "mpos.core"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ApplicationCryptogramType parseACT(int n2) {
            return switch (n2 & 0xC0) {
                case 0 -> ApplicationCryptogramType.AAC;
                case 64 -> ApplicationCryptogramType.TC;
                case 128 -> ApplicationCryptogramType.ARQC;
                default -> ApplicationCryptogramType.RFU;
            };
        }

        public final int parsePaymentSpecificCryptogram(int n2) {
            return n2 & 0x30;
        }

        public final boolean parseAdviceRequired(int n2) {
            return (n2 & 8) != 0;
        }

        @NotNull
        public final ReasonCode parseReasonCode(int n2) {
            return switch (n2 & 7) {
                case 0 -> ReasonCode.NoInfoGiven;
                case 1 -> ReasonCode.ServiceNotAllowed;
                case 2 -> ReasonCode.PinTryLimitExceeded;
                case 3 -> ReasonCode.IssuerAuthenticationFailed;
                default -> ReasonCode.RFU;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lio/mpos/specs/helper/cid/CryptogramInformationData$ReasonCode;", "", "<init>", "(Ljava/lang/String;I)V", "NoInfoGiven", "ServiceNotAllowed", "PinTryLimitExceeded", "IssuerAuthenticationFailed", "RFU", "mpos.core"})
    public static final class ReasonCode
    extends Enum<ReasonCode> {
        public static final /* enum */ ReasonCode NoInfoGiven = new ReasonCode();
        public static final /* enum */ ReasonCode ServiceNotAllowed = new ReasonCode();
        public static final /* enum */ ReasonCode PinTryLimitExceeded = new ReasonCode();
        public static final /* enum */ ReasonCode IssuerAuthenticationFailed = new ReasonCode();
        public static final /* enum */ ReasonCode RFU = new ReasonCode();
        private static final /* synthetic */ ReasonCode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReasonCode[] values() {
            return (ReasonCode[])$VALUES.clone();
        }

        public static ReasonCode valueOf(String value) {
            return Enum.valueOf(ReasonCode.class, value);
        }

        @NotNull
        public static EnumEntries<ReasonCode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = reasonCodeArray = new ReasonCode[]{ReasonCode.NoInfoGiven, ReasonCode.ServiceNotAllowed, ReasonCode.PinTryLimitExceeded, ReasonCode.IssuerAuthenticationFailed, ReasonCode.RFU};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

