/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.iso7816;

import java.nio.ByteBuffer;

public class ApduResponse {
    public static final int CODE_NORMAL_PROCESSING = 16;
    public static final int CODE_WARNING_PROCESSING = 32;
    public static final int CODE_EXECUTION_ERROR = 48;
    public static final int CODE_CHECKING_ERROR = 64;
    private final byte sw1;
    private final byte sw2;
    private byte[] data = null;

    public ApduResponse(byte sw1, byte sw2) {
        this.sw1 = sw1;
        this.sw2 = sw2;
    }

    public ApduResponse(byte sw1, byte sw2, byte[] data) {
        this.sw1 = sw1;
        this.sw2 = sw2;
        this.data = data;
    }

    public byte[] serialize() {
        ByteBuffer byteBuffer;
        if (this.data != null) {
            byteBuffer = ByteBuffer.allocate(this.data.length + 2);
            byteBuffer.put(this.data);
        } else {
            byteBuffer = ByteBuffer.allocate(2);
        }
        byteBuffer.put(this.sw1);
        byteBuffer.put(this.sw2);
        return byteBuffer.array();
    }

    public static ApduResponse deserialize(byte[] raw) {
        int n2 = raw.length;
        if (n2 < 2) {
            throw new IllegalArgumentException("The given byte array is too short (length <= 2)");
        }
        byte[] byArray = new byte[n2 - 2];
        System.arraycopy(raw, 0, byArray, 0, n2 - 2);
        byte by2 = raw[n2 - 2];
        byte by3 = raw[n2 - 1];
        return new ApduResponse(by2, by3, byArray);
    }

    public int getSWCode() {
        if (this.sw1 == -112 && this.sw2 == 0) {
            return 16;
        }
        if (this.sw1 == 97) {
            return 16;
        }
        if (this.sw1 == 98 || this.sw1 == 99) {
            return 32;
        }
        if (this.sw1 == 100 || this.sw1 == 101 || this.sw1 == 102) {
            return 48;
        }
        if (this.sw1 == 103 && this.sw2 == 0) {
            return 64;
        }
        if (this.sw1 == 104 || this.sw1 == 105 || this.sw1 == 106) {
            return 64;
        }
        if (this.sw1 == 107 && this.sw2 == 0) {
            return 64;
        }
        if (this.sw1 == 108) {
            return 64;
        }
        if (this.sw1 == 109 && this.sw2 == 0) {
            return 64;
        }
        if (this.sw1 == 110 && this.sw2 == 0) {
            return 64;
        }
        if (this.sw1 == 111 && this.sw2 == 0) {
            return 64;
        }
        return 48;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public byte getSw2() {
        return this.sw2;
    }

    public byte getSw1() {
        return this.sw1;
    }
}

