/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.mpivipa;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedBinaryTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagMpiVipaDecision
extends MappedBinaryTlv {
    public static final int TAG = 192;
    public static final byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(192);
    public static final byte[] DECISION_FALSE = new byte[]{0};
    public static final byte[] DECISION_TRUE = new byte[]{1};

    public TagMpiVipaDecision(boolean decision) {
        super(TAG_BYTES, decision ? DECISION_TRUE : DECISION_FALSE);
    }

    public TagMpiVipaDecision(byte[] value) {
        super(TAG_BYTES, value);
    }

    public static TagMpiVipaDecision wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of=" + ByteHelper.toHexString(TAG_BYTES));
        }
        return new TagMpiVipaDecision(tlv.getValue());
    }

    @Override
    public String getDescription() {
        return "MIURA and VIPA DECISION";
    }
}

