/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.transactionprovider;

import io.mpos.errors.MposError;
import io.mpos.provider.Provider;
import io.mpos.provider.listener.SendCustomerReceiptListener;
import io.mpos.provider.listener.TransactionLookupWithTransactionIdentifierListener;
import io.mpos.shared.helper.ParameterValidator;
import io.mpos.shared.transactionprovider.ProcessTracker;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.util.TransactionConverterKt;
import io.mpos.transactionprovider.FilterParameters;
import io.mpos.transactionprovider.LookupTransactionListener;
import io.mpos.transactionprovider.QueryTransactionsListener;
import io.mpos.transactionprovider.SendReceiptListener;
import io.mpos.transactionprovider.TransactionModule;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultTransactionModule
implements TransactionModule {
    private Provider mProvider;
    private ProcessTracker mProcessTracker;

    public DefaultTransactionModule(Provider provider, ProcessTracker processTracker) {
        this.mProvider = provider;
        this.mProcessTracker = processTracker;
    }

    public void lookupTransaction(final String transactionIdentifier, final LookupTransactionListener listener) {
        ParameterValidator.checkNullOrEmpty(Arrays.asList(transactionIdentifier), Arrays.asList("transactionIdentifier"));
        this.mProcessTracker.incrementNonCardProcessOngoing();
        this.mProvider.addTransactionLookupWithTransactionIdentifierListener(new TransactionLookupWithTransactionIdentifierListener(){

            @Override
            public void onTransactionLookupWithTransactionIdentifierSuccess(String returnedTransactionIdentifier, BaseTransaction transaction) {
                if (returnedTransactionIdentifier != null && returnedTransactionIdentifier.equals(transactionIdentifier)) {
                    DefaultTransactionModule.this.mProcessTracker.decrementNonCardProcessOngoing();
                    listener.onCompleted(transactionIdentifier, TransactionConverterKt.toTransaction(transaction), null);
                    DefaultTransactionModule.this.mProvider.removeTransactionLookupWithTransactionIdentifierListener(this);
                }
            }

            @Override
            public void onTransactionLookupWithTransactionIdentifierFailure(String returnedTransactionIdentifier, MposError error) {
                if (returnedTransactionIdentifier != null && returnedTransactionIdentifier.equals(transactionIdentifier)) {
                    DefaultTransactionModule.this.mProcessTracker.decrementNonCardProcessOngoing();
                    listener.onCompleted(transactionIdentifier, null, error);
                    DefaultTransactionModule.this.mProvider.removeTransactionLookupWithTransactionIdentifierListener(this);
                }
            }
        });
        this.mProvider.lookupTransactionWithTransactionIdentifier(transactionIdentifier);
    }

    public void queryTransactions(FilterParameters filterParameters, QueryTransactionsListener listener) {
        this.queryTransactions(filterParameters, false, 0, 20, listener);
    }

    public void queryTransactions(FilterParameters filterParameters, boolean includeReceipts, int offset, int limit, final QueryTransactionsListener listener) {
        if (filterParameters == null) {
            filterParameters = new FilterParameters.Builder().build();
        }
        this.mProcessTracker.incrementNonCardProcessOngoing();
        this.mProvider.addQueryTransactionsListener(new io.mpos.provider.listener.QueryTransactionsListener(){

            @Override
            public void onQueryTransactionsSuccess(FilterParameters filterParameters, boolean includeReceipts, int offset, int limit, List<BaseTransaction> transactions) {
                DefaultTransactionModule.this.mProcessTracker.decrementNonCardProcessOngoing();
                listener.onCompleted(filterParameters, includeReceipts, offset, limit, transactions.stream().map(TransactionConverterKt::toTransaction).collect(Collectors.toList()), null);
                DefaultTransactionModule.this.mProvider.removeQueryTransactionsListener(this);
            }

            @Override
            public void onQueryTransactionsFailure(FilterParameters filterParameters, boolean includeReceipts, int offset, int limit, MposError error) {
                DefaultTransactionModule.this.mProcessTracker.decrementNonCardProcessOngoing();
                listener.onCompleted(filterParameters, includeReceipts, offset, limit, null, error);
                DefaultTransactionModule.this.mProvider.removeQueryTransactionsListener(this);
            }
        });
        this.mProvider.queryTransactions(filterParameters, includeReceipts, offset, limit);
    }

    public void sendCustomerReceiptForTransaction(final String transactionIdentifier, String email, final SendReceiptListener listener) {
        ParameterValidator.checkNullOrEmpty(Arrays.asList(transactionIdentifier, email), Arrays.asList("transactionIdentifier", "email"));
        this.mProcessTracker.incrementNonCardProcessOngoing();
        this.mProvider.addSendCustomerReceiptListener(new SendCustomerReceiptListener(){

            @Override
            public void onCustomerReceiptSendSuccess(String returnedTransactionIdentifier) {
                if (transactionIdentifier.equals(returnedTransactionIdentifier)) {
                    DefaultTransactionModule.this.mProcessTracker.decrementNonCardProcessOngoing();
                    listener.onCompleted(transactionIdentifier, null);
                    DefaultTransactionModule.this.mProvider.removeSendCustomerReceiptListener(this);
                    DefaultTransactionModule.this.mProvider.removeSendCustomerReceiptListener(this);
                }
            }

            @Override
            public void onCustomerReceiptSendFailure(String returnedTransactionIdentifier, MposError error) {
                if (transactionIdentifier.equals(returnedTransactionIdentifier)) {
                    DefaultTransactionModule.this.mProcessTracker.decrementNonCardProcessOngoing();
                    listener.onCompleted(transactionIdentifier, error);
                    DefaultTransactionModule.this.mProvider.removeSendCustomerReceiptListener(this);
                }
            }
        });
        this.mProvider.sendCustomerReceiptForTransaction(transactionIdentifier, email);
    }
}

