/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.transactionprovider.accessibility;

import io.mpos.accessories.AccessibilityModeFriendlyAccessory;
import io.mpos.accessories.Accessory;
import io.mpos.paymentdetails.PinInformationStatus;
import io.mpos.shared.transactionprovider.DefaultAccessoryModule;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.transactionprovider.AccessibilityModule;
import io.mpos.transactionprovider.accessibility.RnibPinPadUpdatesHandler;
import io.mpos.transactionprovider.accessibility.RnibSpeaker;
import io.mpos.transactionprovider.accessibility.RnibTextToSpeechDisabler;
import io.mpos.transactionprovider.accessibility.RnibTextToSpeechStateHolder;
import io.mpos.transactionprovider.accessibility.RnibTransactionStateUpdatesHandler;
import io.mpos.transactions.TransactionState;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u0011H\u0016J\u001a\u0010#\u001a\u00020\u00192\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00190%J\n\u0010&\u001a\u0004\u0018\u00010'H\u0002J\b\u0010(\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/mpos/transactionprovider/accessibility/RnibTextToSpeechManager;", "", "accessoryModule", "Lio/mpos/shared/transactionprovider/DefaultAccessoryModule;", "stateHolder", "Lio/mpos/transactionprovider/accessibility/RnibTextToSpeechStateHolder;", "speaker", "Lio/mpos/transactionprovider/accessibility/RnibSpeaker;", "transactionStateUpdatesHandler", "Lio/mpos/transactionprovider/accessibility/RnibTransactionStateUpdatesHandler;", "pinPadUpdatesHandler", "Lio/mpos/transactionprovider/accessibility/RnibPinPadUpdatesHandler;", "rnibTextToSpeechDisabler", "Lio/mpos/transactionprovider/accessibility/RnibTextToSpeechDisabler;", "<init>", "(Lio/mpos/shared/transactionprovider/DefaultAccessoryModule;Lio/mpos/transactionprovider/accessibility/RnibTextToSpeechStateHolder;Lio/mpos/transactionprovider/accessibility/RnibSpeaker;Lio/mpos/transactionprovider/accessibility/RnibTransactionStateUpdatesHandler;Lio/mpos/transactionprovider/accessibility/RnibPinPadUpdatesHandler;Lio/mpos/transactionprovider/accessibility/RnibTextToSpeechDisabler;)V", "isEnabled", "", "enableTextToSpeech", "Lio/mpos/transactionprovider/AccessibilityModule$EnableAccessibilityModeResult;", "enabled", "tryToEnableTextToSpeech", "accessory", "Lio/mpos/accessories/AccessibilityModeFriendlyAccessory;", "disableTextToSpeech", "", "transactionStateChanged", "transaction", "Lio/mpos/shared/transactions/BaseTransaction;", "pinStateChanged", "newState", "Lio/mpos/paymentdetails/PinInformationStatus;", "numberOfPinDigits", "", "isTextToSpeechAvailable", "setIsEnabledListener", "listener", "Lkotlin/Function1;", "getConnectedAccessory", "Lio/mpos/accessories/Accessory;", "isTransactionInProperState", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nRnibTextToSpeechManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RnibTextToSpeechManager.kt\nio/mpos/transactionprovider/accessibility/RnibTextToSpeechManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public class RnibTextToSpeechManager {
    @NotNull
    private final DefaultAccessoryModule accessoryModule;
    @NotNull
    private final RnibTextToSpeechStateHolder stateHolder;
    @NotNull
    private final RnibSpeaker speaker;
    @NotNull
    private final RnibTransactionStateUpdatesHandler transactionStateUpdatesHandler;
    @NotNull
    private final RnibPinPadUpdatesHandler pinPadUpdatesHandler;

    public RnibTextToSpeechManager(@NotNull DefaultAccessoryModule accessoryModule, @NotNull RnibTextToSpeechStateHolder stateHolder, @NotNull RnibSpeaker speaker, @NotNull RnibTransactionStateUpdatesHandler transactionStateUpdatesHandler, @NotNull RnibPinPadUpdatesHandler pinPadUpdatesHandler, @NotNull RnibTextToSpeechDisabler rnibTextToSpeechDisabler) {
        Intrinsics.checkNotNullParameter((Object)accessoryModule, (String)"");
        Intrinsics.checkNotNullParameter((Object)stateHolder, (String)"");
        Intrinsics.checkNotNullParameter((Object)speaker, (String)"");
        Intrinsics.checkNotNullParameter((Object)transactionStateUpdatesHandler, (String)"");
        Intrinsics.checkNotNullParameter((Object)pinPadUpdatesHandler, (String)"");
        Intrinsics.checkNotNullParameter((Object)rnibTextToSpeechDisabler, (String)"");
        this.accessoryModule = accessoryModule;
        this.stateHolder = stateHolder;
        this.speaker = speaker;
        this.transactionStateUpdatesHandler = transactionStateUpdatesHandler;
        this.pinPadUpdatesHandler = pinPadUpdatesHandler;
        rnibTextToSpeechDisabler.setOnDisabledFunction((Function0<Unit>)((Function0)() -> RnibTextToSpeechManager._init_$lambda$0(this)));
    }

    public final boolean isEnabled() {
        return this.stateHolder.getEnabled();
    }

    @NotNull
    public final AccessibilityModule.EnableAccessibilityModeResult enableTextToSpeech(boolean enabled) {
        Accessory accessory = this.getConnectedAccessory();
        return !this.speaker.isSpeakingAvailable() ? AccessibilityModule.EnableAccessibilityModeResult.ERROR_INVALID_PLATFORM : (accessory == null ? AccessibilityModule.EnableAccessibilityModeResult.ERROR_ACCESSORY_NOT_CONNECTED : (!(accessory instanceof AccessibilityModeFriendlyAccessory) ? AccessibilityModule.EnableAccessibilityModeResult.ERROR_INVALID_ACCESSORY : (!this.isTransactionInProperState() ? AccessibilityModule.EnableAccessibilityModeResult.ERROR_INVALID_STATE : (this.stateHolder.getEnabled() ? AccessibilityModule.EnableAccessibilityModeResult.ERROR_ALREADY_ENABLED : this.tryToEnableTextToSpeech(enabled, (AccessibilityModeFriendlyAccessory)accessory)))));
    }

    private final AccessibilityModule.EnableAccessibilityModeResult tryToEnableTextToSpeech(boolean enabled, AccessibilityModeFriendlyAccessory accessory) {
        AccessibilityModule.EnableAccessibilityModeResult enableAccessibilityModeResult;
        boolean bl2 = accessory.setAccessibilityModeEnabled(true);
        if (bl2) {
            this.stateHolder.setEnabled(enabled);
            BaseTransaction baseTransaction = this.transactionStateUpdatesHandler.getTransaction();
            if (baseTransaction != null) {
                BaseTransaction baseTransaction2 = baseTransaction;
                this.speaker.readIntro(baseTransaction2);
            }
            enableAccessibilityModeResult = AccessibilityModule.EnableAccessibilityModeResult.SUCCESS;
        } else {
            enableAccessibilityModeResult = AccessibilityModule.EnableAccessibilityModeResult.ERROR_ACCESSORY_FAILED_TO_ENABLE;
        }
        return enableAccessibilityModeResult;
    }

    public final void disableTextToSpeech() {
        block0: {
            Accessory accessory;
            this.speaker.stopSpeaking();
            this.stateHolder.setEnabled(false);
            Accessory accessory2 = this.getConnectedAccessory();
            if (accessory2 == null || !((accessory = accessory2) instanceof AccessibilityModeFriendlyAccessory)) break block0;
            ((AccessibilityModeFriendlyAccessory)accessory).setAccessibilityModeEnabled(false);
        }
    }

    public final void transactionStateChanged(@NotNull BaseTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"");
        this.transactionStateUpdatesHandler.transactionStateChanged(transaction);
    }

    public final void pinStateChanged(@NotNull PinInformationStatus newState, int numberOfPinDigits) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"");
        this.pinPadUpdatesHandler.pinStateChanged(newState, numberOfPinDigits);
    }

    public boolean isTextToSpeechAvailable() {
        boolean bl2 = this.speaker.isSpeakingAvailable();
        Accessory accessory = this.getConnectedAccessory();
        AccessibilityModeFriendlyAccessory accessibilityModeFriendlyAccessory = accessory instanceof AccessibilityModeFriendlyAccessory ? (AccessibilityModeFriendlyAccessory)accessory : null;
        boolean bl3 = accessibilityModeFriendlyAccessory != null ? accessibilityModeFriendlyAccessory.isAccessibilityModeSupported() : false;
        return bl2 && bl3;
    }

    public final void setIsEnabledListener(@NotNull Function1<? super Boolean, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"");
        this.stateHolder.setIsEnabledListener(listener);
    }

    private final Accessory getConnectedAccessory() {
        return this.accessoryModule.getConnectedAccessory();
    }

    private final boolean isTransactionInProperState() {
        Object[] objectArray = new TransactionState[]{TransactionState.IDLE, TransactionState.AWAITING_CARD};
        BaseTransaction baseTransaction = this.transactionStateUpdatesHandler.getTransaction();
        return CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)(baseTransaction != null ? baseTransaction.getState() : null));
    }

    private static final Unit _init_$lambda$0(RnibTextToSpeechManager this$0) {
        this$0.disableTextToSpeech();
        return Unit.INSTANCE;
    }
}

