/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.transactionprovider.processparameters.steps.tipping;

import io.mpos.shared.transactionprovider.processparameters.steps.tipping.TippingUtils;
import io.mpos.shared.transactions.CurrencyWrapper;
import io.mpos.transactionprovider.processparameters.steps.tipping.TippingParameters;
import io.mpos.transactions.Currency;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001e\u00a8\u0006#"}, d2={"Lio/mpos/transactionprovider/processparameters/steps/tipping/PercentageTippingOptions;", "", "tippingParameters", "Lio/mpos/transactionprovider/processparameters/steps/tipping/TippingParameters$PercentageChoice;", "originalAmount", "Ljava/math/BigDecimal;", "currency", "Lio/mpos/transactions/Currency;", "<init>", "(Lio/mpos/transactionprovider/processparameters/steps/tipping/TippingParameters$PercentageChoice;Ljava/math/BigDecimal;Lio/mpos/transactions/Currency;)V", "currencyWrapper", "Lio/mpos/shared/transactions/CurrencyWrapper;", "fractionDigits", "", "percentage1", "getPercentage1", "()Ljava/math/BigDecimal;", "percentage2", "getPercentage2", "percentage3", "getPercentage3", "tip1", "getTip1", "tip2", "getTip2", "tip3", "getTip3", "tip1String", "", "getTip1String", "()Ljava/lang/String;", "tip2String", "getTip2String", "tip3String", "getTip3String", "mpos.core"})
public final class PercentageTippingOptions {
    @NotNull
    private final CurrencyWrapper currencyWrapper;
    private final int fractionDigits;
    @NotNull
    private final BigDecimal percentage1;
    @NotNull
    private final BigDecimal percentage2;
    @NotNull
    private final BigDecimal percentage3;
    @NotNull
    private final BigDecimal tip1;
    @NotNull
    private final BigDecimal tip2;
    @NotNull
    private final BigDecimal tip3;
    @NotNull
    private final String tip1String;
    @NotNull
    private final String tip2String;
    @NotNull
    private final String tip3String;

    public PercentageTippingOptions(@NotNull TippingParameters.PercentageChoice tippingParameters, @NotNull BigDecimal originalAmount, @NotNull Currency currency) {
        Intrinsics.checkNotNullParameter((Object)tippingParameters, (String)"");
        Intrinsics.checkNotNullParameter((Object)originalAmount, (String)"");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"");
        this.currencyWrapper = new CurrencyWrapper(currency, null, 2, null);
        this.fractionDigits = this.currencyWrapper.getExponent();
        this.percentage1 = tippingParameters.getPercentage1();
        this.percentage2 = tippingParameters.getPercentage2();
        this.percentage3 = tippingParameters.getPercentage3();
        this.tip1 = TippingUtils.INSTANCE.tipAmountForPercentage(originalAmount, this.percentage1, this.fractionDigits);
        this.tip2 = TippingUtils.INSTANCE.tipAmountForPercentage(originalAmount, this.percentage2, this.fractionDigits);
        this.tip3 = TippingUtils.INSTANCE.tipAmountForPercentage(originalAmount, this.percentage3, this.fractionDigits);
        this.tip1String = this.currencyWrapper.formatAmount(this.tip1);
        this.tip2String = this.currencyWrapper.formatAmount(this.tip2);
        this.tip3String = this.currencyWrapper.formatAmount(this.tip3);
    }

    @NotNull
    public final BigDecimal getPercentage1() {
        return this.percentage1;
    }

    @NotNull
    public final BigDecimal getPercentage2() {
        return this.percentage2;
    }

    @NotNull
    public final BigDecimal getPercentage3() {
        return this.percentage3;
    }

    @NotNull
    public final BigDecimal getTip1() {
        return this.tip1;
    }

    @NotNull
    public final BigDecimal getTip2() {
        return this.tip2;
    }

    @NotNull
    public final BigDecimal getTip3() {
        return this.tip3;
    }

    @NotNull
    public final String getTip1String() {
        return this.tip1String;
    }

    @NotNull
    public final String getTip2String() {
        return this.tip2String;
    }

    @NotNull
    public final String getTip3String() {
        return this.tip3String;
    }
}

