/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.transactions.parameters.validation;

import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.shared.errors.DefaultMposError;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class ParametersValidationUtils {
    private static Pattern SALE_ORGANIZATION_ID_REGEX = null;
    private static Pattern SUB_MERCHANT_ID_REGEX = null;
    private static Pattern MERCHANT_DESCRIPTOR_NAME_REGEX = null;
    private static Pattern MERCHANT_TAX_ID_REGEX = null;
    private static Pattern SALE_SLIP_NUMBER_REGEX = null;
    private static Pattern PLAN_TYPE_REGEX = null;
    private static Pattern NUMBER_OF_INSTALLMENTS_REGEX = null;
    private static final BigDecimal MAX_TAX_AMOUNT = new BigDecimal("999999.99");
    private static final BigDecimal MAX_LOCAL_OR_NATIONAL_AMOUNT = new BigDecimal("9999999999.99");

    public static boolean assertValidMerchantTaxId(String taxId) {
        if (taxId == null) {
            return true;
        }
        if (MERCHANT_TAX_ID_REGEX == null) {
            MERCHANT_TAX_ID_REGEX = Pattern.compile("^.{0,15}$");
        }
        if (!MERCHANT_TAX_ID_REGEX.matcher(taxId).matches()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("tax id '%s' needs to follow the pattern '%s'", taxId, MERCHANT_TAX_ID_REGEX.toString())));
        }
        return true;
    }

    public static boolean assertValidSaleOrganizationId(String saleOrganizationId) {
        if (saleOrganizationId == null) {
            return true;
        }
        if (SALE_ORGANIZATION_ID_REGEX == null) {
            SALE_ORGANIZATION_ID_REGEX = Pattern.compile("^[0-9]{1,11}$");
        }
        if (!SALE_ORGANIZATION_ID_REGEX.matcher(saleOrganizationId).matches()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("sale organization id '%s' needs to follow the pattern '%s'", saleOrganizationId, SALE_ORGANIZATION_ID_REGEX.toString())));
        }
        return true;
    }

    public static boolean assertValidSubMerchantId(String subMerchantId) {
        if (subMerchantId == null) {
            return true;
        }
        if (SUB_MERCHANT_ID_REGEX == null) {
            SUB_MERCHANT_ID_REGEX = Pattern.compile("^.{0,20}$");
        }
        if (!SUB_MERCHANT_ID_REGEX.matcher(subMerchantId).matches()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("sub merchant id '%s' needs to follow the pattern '%s'", subMerchantId, SUB_MERCHANT_ID_REGEX.toString())));
        }
        return true;
    }

    public static boolean assertValidMerchantDescriptorName(String merchantDescriptorName) {
        if (merchantDescriptorName == null) {
            return true;
        }
        if (MERCHANT_DESCRIPTOR_NAME_REGEX == null) {
            MERCHANT_DESCRIPTOR_NAME_REGEX = Pattern.compile("^.{0,23}$");
        }
        if (!MERCHANT_DESCRIPTOR_NAME_REGEX.matcher(merchantDescriptorName).matches()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("descriptor name '%s' needs to follow the pattern '%s'", merchantDescriptorName, MERCHANT_DESCRIPTOR_NAME_REGEX.toString())));
        }
        return true;
    }

    public static boolean assertValidSalesSlipNumber(String salesSlipNumber) {
        if (salesSlipNumber == null) {
            return true;
        }
        if (SALE_SLIP_NUMBER_REGEX == null) {
            SALE_SLIP_NUMBER_REGEX = Pattern.compile("^[0-9]{1,8}$");
        }
        if (!SALE_SLIP_NUMBER_REGEX.matcher(salesSlipNumber).matches()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("sale slip number '%s' needs to follow the pattern '%s'", salesSlipNumber, SALE_SLIP_NUMBER_REGEX.toString())));
        }
        return true;
    }

    public static boolean assertValidTaxAmount(BigDecimal taxAmount) {
        if (taxAmount == null) {
            return true;
        }
        if (MAX_TAX_AMOUNT.compareTo(taxAmount) < 0) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("tax amount '%s' needs to less than or equal to '%s'", taxAmount, MAX_TAX_AMOUNT)));
        }
        return true;
    }

    public static boolean assertValidLocalOrNationalTaxAmount(BigDecimal localTaxAmount) {
        if (localTaxAmount == null) {
            return true;
        }
        if (MAX_LOCAL_OR_NATIONAL_AMOUNT.compareTo(localTaxAmount) < 0) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("local or national tax amount '%s' needs to less than or equal to '%s'", localTaxAmount, MAX_LOCAL_OR_NATIONAL_AMOUNT)));
        }
        return true;
    }

    public static boolean assertValidPlanType(String planType) {
        if (planType == null) {
            return true;
        }
        if (PLAN_TYPE_REGEX == null) {
            PLAN_TYPE_REGEX = Pattern.compile("^.{0,2}$");
        }
        if (!PLAN_TYPE_REGEX.matcher(planType).matches()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("plan type '%s' needs to follow the pattern '%s'", planType, PLAN_TYPE_REGEX.toString())));
        }
        return true;
    }

    public static boolean assertValidNumberOfInstallments(String numberOfInstallments) {
        if (numberOfInstallments == null) {
            return true;
        }
        if (NUMBER_OF_INSTALLMENTS_REGEX == null) {
            NUMBER_OF_INSTALLMENTS_REGEX = Pattern.compile("^[0-9]{1,2}$");
        }
        if (!NUMBER_OF_INSTALLMENTS_REGEX.matcher(numberOfInstallments).matches()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("number of installments '%s' needs to follow the pattern '%s'", numberOfInstallments, NUMBER_OF_INSTALLMENTS_REGEX.toString())));
        }
        return true;
    }
}

