/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.accessories.miura;

import bolts.Task;
import io.mpos.accessories.Accessory;
import io.mpos.accessories.AccessoryBatteryState;
import io.mpos.accessories.AccessoryConnectionState;
import io.mpos.accessories.AccessoryDetails;
import io.mpos.accessories.AccessoryFamily;
import io.mpos.accessories.AccessoryState;
import io.mpos.accessories.AccessoryType;
import io.mpos.accessories.components.AccessoryComponent;
import io.mpos.accessories.components.AccessoryComponentType;
import io.mpos.accessories.displayupdate.DisplayUpdateSupport;
import io.mpos.accessories.displayupdate.DisplayUpdateType;
import io.mpos.accessories.events.AccessoryCardEvent;
import io.mpos.accessories.events.AccessoryKeyEvent;
import io.mpos.accessories.miura.d;
import io.mpos.accessories.miura.messages.response.a;
import io.mpos.accessories.miura.modules.MiuraCardProcessingModule;
import io.mpos.accessories.miura.modules.MiuraDisplayModule;
import io.mpos.accessories.miura.modules.MiuraInteractionModule;
import io.mpos.accessories.miura.modules.MiuraLogModule;
import io.mpos.accessories.miura.modules.MiuraSecurityModule;
import io.mpos.accessories.miura.modules.MiuraStatusModule;
import io.mpos.accessories.miura.modules.MiuraSystemModule;
import io.mpos.accessories.miura.obfuscated.aT;
import io.mpos.accessories.miura.obfuscated.ae;
import io.mpos.accessories.miura.obfuscated.ah;
import io.mpos.accessories.miura.obfuscated.ai;
import io.mpos.accessories.miura.obfuscated.ak;
import io.mpos.accessories.miura.obfuscated.al;
import io.mpos.accessories.miura.obfuscated.bc;
import io.mpos.accessories.miura.obfuscated.bd;
import io.mpos.accessories.miura.obfuscated.be;
import io.mpos.accessories.miura.obfuscated.bf;
import io.mpos.accessories.miura.obfuscated.bj;
import io.mpos.accessories.miura.obfuscated.bk;
import io.mpos.accessories.miura.obfuscated.bp;
import io.mpos.accessories.miura.obfuscated.bq;
import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.accessories.payment.PaymentAccessoryFeatures;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.paymentdetails.PinInformation;
import io.mpos.paymentdetails.PinInformationStatus;
import io.mpos.shared.accessories.DefaultAccessoryDetails;
import io.mpos.shared.accessories.EncryptionDetails;
import io.mpos.shared.accessories.EncryptionKeyInjectionStrategy;
import io.mpos.shared.accessories.PaymentAccessoryRequirement;
import io.mpos.shared.accessories.displayupdate.DefaultPINDisplayUpdateSupport;
import io.mpos.shared.accessories.events.AccessoryInteractionUpdateEvent;
import io.mpos.shared.accessories.modules.AbstractCardProcessingModule;
import io.mpos.shared.accessories.modules.listener.AccessoryBatteryStatusUpdateListener;
import io.mpos.shared.accessories.modules.listener.AccessoryCardStatusUpdateListener;
import io.mpos.shared.accessories.modules.listener.AccessoryInteractionUpdateEventListener;
import io.mpos.shared.accessories.modules.listener.AccessoryKeyUpdateListener;
import io.mpos.shared.accessories.modules.listener.AccessoryStatusUpdateListener;
import io.mpos.shared.accessories.modules.listener.DisplayIdleScreenListener;
import io.mpos.shared.accessories.modules.listener.EncryptionGetStatusListener;
import io.mpos.shared.accessories.modules.listener.SystemGetInformationListener;
import io.mpos.shared.accessories.modules.listener.SystemInitializeListener;
import io.mpos.shared.accessories.mpivipa.MpiVipaChainedMessageReader;
import io.mpos.shared.accessories.payment.AbstractPaymentAccessory;
import io.mpos.shared.communicationmodules.CommunicationDelegate;
import io.mpos.shared.communicationmodules.CommunicationModule;
import io.mpos.shared.communicationmodules.SuccessFailureListener;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.events.BusProvider;
import io.mpos.shared.events.accessorycomponent.AccessoryBatteryStateChangedBusEvent;
import io.mpos.shared.events.accessorycomponent.AccessoryCardStateChangedBusEvent;
import io.mpos.shared.events.accessorycomponent.AccessoryKeyPressedBusEvent;
import io.mpos.shared.events.providercomponent.AccessoryDisplayedTextUpdateBusEvent;
import io.mpos.shared.events.providercomponent.AccessoryStateChangedBusEvent;
import io.mpos.shared.paymentdetails.DefaultPinInformation;
import io.mpos.shared.paymentdetails.IccInformation;
import io.mpos.shared.paymentdetails.PaymentDetailsCustomerVerificationDetailed;
import io.mpos.shared.provider.CardHelper;
import io.mpos.shared.provider.WhitelistAccessory;
import io.mpos.shared.provider.WhitelistAccessoryRequirement;
import io.mpos.shared.workflows.DefaultTransactionWorkflow;
import io.mpos.shared.workflows.PaymentChargeRefundWorkflow;
import io.mpos.shared.workflows.PaymentWorkflowState;
import io.mpos.shared.workflows.WorkflowInteraction;
import io.mpos.shared.workflows.accessory.ConfigurationItem;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.TLVHelper;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.GenericEmvExtractor;
import io.mpos.specs.helper.IsoBlockFrameReader;
import io.mpos.specs.iso7816.IsoBlockFrame;
import io.mpos.transactions.TransactionState;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MiuraPaymentAccessory
extends AbstractPaymentAccessory {
    public static final d MPI_VERSION_EXTENDED_DEVICE_INFO = new d("1-30");
    private static final d a = new d("1-30");
    private static final d b = new d("1-59");
    private static final d c = new d("1-26");
    private static final List<String> d = Arrays.asList("cfg", "txt");
    private static final d e = new d("1-29");
    private static final d f = new d("1-51");
    private IsoBlockFrameReader g = new IsoBlockFrameReader();
    private MpiVipaChainedMessageReader h = new MpiVipaChainedMessageReader();
    private final Deque<io.mpos.accessories.miura.obfuscated.a> i;
    private al j;
    private ah k;
    private ai l;
    private ae m;
    private SuccessFailureListener n;
    private SuccessFailureListener o;
    private boolean p = false;
    private boolean q = false;

    /*
     * WARNING - void declaration
     */
    public MiuraPaymentAccessory(CommunicationModule communicationModule) {
        super((CommunicationModule)var1_1);
        void var1_1;
        this.mAccessoryType = AccessoryType.MIURA_SHUTTLE;
        this.mAccessoryFamily = AccessoryFamily.MIURA_MPI;
        this.mAccessoryDetails = new DefaultAccessoryDetails(null, null, null, null);
        this.mPaymentAccessoryFeatures = EnumSet.of(PaymentAccessoryFeatures.MAGNETIC_STRIPE, new PaymentAccessoryFeatures[]{PaymentAccessoryFeatures.ICC, PaymentAccessoryFeatures.EMV_KERNEL, PaymentAccessoryFeatures.SRED_ENCRYPTION, PaymentAccessoryFeatures.KEYPAD, PaymentAccessoryFeatures.DISPLAY, PaymentAccessoryFeatures.ONLINE_TRANSACTIONS, PaymentAccessoryFeatures.OFFLINE_PIN, PaymentAccessoryFeatures.REFUND});
        this.mEncryptionKeyInjectionStrategy = EncryptionKeyInjectionStrategy.KEY_GENERATION;
        this.i = new ArrayDeque<io.mpos.accessories.miura.obfuscated.a>();
        this.a();
        this.systemModule = new MiuraSystemModule((PaymentAccessory)this);
        this.cardProcessingModule = new MiuraCardProcessingModule((PaymentAccessory)this);
        this.interactionModule = new MiuraInteractionModule((PaymentAccessory)this);
        this.statusModule = new MiuraStatusModule((PaymentAccessory)this);
        this.displayModule = new MiuraDisplayModule((PaymentAccessory)this);
        this.securityModule = new MiuraSecurityModule((PaymentAccessory)this);
        this.logModule = new MiuraLogModule((PaymentAccessory)this);
        this.k = new ah(this);
        this.l = new ai(this.k);
        MiuraPaymentAccessory miuraPaymentAccessory = this;
        this.j = new al(new ak(miuraPaymentAccessory, miuraPaymentAccessory.k));
        this.m = new ae(this);
    }

    /*
     * WARNING - void declaration
     */
    public void addAndSetupChainHandler(io.mpos.accessories.miura.obfuscated.a chainHandler) {
        void var1_1;
        String cfr_ignored_0 = "request to add handler " + chainHandler;
        Deque<io.mpos.accessories.miura.obfuscated.a> deque = this.i;
        synchronized (deque) {
            this.i.add(chainHandler);
        }
        var1_1.b();
        String cfr_ignored_1 = "now having " + this.i.size() + " handler active";
    }

    /*
     * WARNING - void declaration
     */
    public void removeChainHandler(io.mpos.accessories.miura.obfuscated.a chainHandler) {
        String cfr_ignored_0 = "request to remove handler " + chainHandler;
        Deque<io.mpos.accessories.miura.obfuscated.a> deque = this.i;
        synchronized (deque) {
            void var1_1;
            this.i.remove(var1_1);
        }
        String cfr_ignored_1 = "now having " + this.i.size() + " handler active";
    }

    public void resetModules() {
        String cfr_ignored_0 = "request for modules to abort, current count " + this.i.size();
        Deque<io.mpos.accessories.miura.obfuscated.a> deque = this.i;
        synchronized (deque) {
            LinkedList<io.mpos.accessories.miura.obfuscated.a> linkedList = new LinkedList<io.mpos.accessories.miura.obfuscated.a>();
            for (io.mpos.accessories.miura.obfuscated.a a2 : this.i) {
                if (!a2.d()) continue;
                linkedList.add(a2);
            }
            this.i.removeAll(linkedList);
        }
        String cfr_ignored_1 = "now having " + this.i.size() + " handler active";
    }

    public List<byte[]> nativelySupportedStrongCustomerAuthenticationARCs() {
        return Arrays.asList("70".getBytes(), "1A".getBytes());
    }

    private void a() {
        Deque<io.mpos.accessories.miura.obfuscated.a> deque = this.i;
        synchronized (deque) {
            for (io.mpos.accessories.miura.obfuscated.a a2 : this.i) {
                a2.c();
            }
            this.i.clear();
        }
        String cfr_ignored_0 = "now having " + this.i.size() + " handler active";
    }

    public void handleQueuedData() {
        Object object3 = this.getCurrentQueuedData();
        try {
            this.g.process((byte[])object3);
        }
        catch (Exception exception) {
            Log.e((String)"MiuraPaymentAccessory", (String)"FrameReader can't process data", (Throwable)exception);
        }
        while (this.g.hasCompleteFrame()) {
            object3 = this.g.getNextFrame();
            Object object2 = null;
            try {
                object2 = this.h.process((IsoBlockFrame)object3);
            }
            catch (Exception exception) {
                Log.e((String)"MiuraPaymentAccessory", (String)"FrameReader can't process frame", (Throwable)exception);
            }
            if (object2 == null) continue;
            a a3 = io.mpos.accessories.miura.messages.response.a.parseMagicIgnoreParseErrors((IsoBlockFrame)object2);
            object3 = (Object)a3;
            String cfr_ignored_0 = "got miura response: " + a3;
            object3.serialize();
            MiuraPaymentAccessory miuraPaymentAccessory = this;
            object2 = object3;
            object3 = (Object)miuraPaymentAccessory;
            Deque<io.mpos.accessories.miura.obfuscated.a> deque = miuraPaymentAccessory.i;
            synchronized (deque) {
                object3 = ((MiuraPaymentAccessory)((Object)object3)).i.descendingIterator();
                LinkedList<Object> linkedList = new LinkedList<Object>();
                while (object3.hasNext()) {
                    io.mpos.accessories.miura.obfuscated.a a4 = (io.mpos.accessories.miura.obfuscated.a)object3.next();
                    if (!a4.c((a)((Object)object2))) continue;
                    linkedList.add(a4);
                }
                if (linkedList.size() == 0) {
                    continue;
                }
                for (Object object3 : linkedList) {
                    Log.i((String)"MiuraPaymentAccessory", (String)("dispatching response to handler " + (io.mpos.accessories.miura.obfuscated.a)object3));
                    ((io.mpos.accessories.miura.obfuscated.a)object3).a((a)((Object)object2));
                    if (((a)((Object)object2)).e()) continue;
                    if (linkedList.size() <= 1) break;
                    String cfr_ignored_1 = "multiple handlers found but notified only first: " + linkedList.stream().map(a2 -> a2.getClass().toString()).collect(Collectors.joining(",", "", ""));
                    break;
                }
            }
        }
    }

    public boolean configurationUpdateRequired(WhitelistAccessory whitelistAccessory) {
        Iterator iterator;
        if (whitelistAccessory.getRequiredConfiguration() == null) {
            return false;
        }
        String cfr_ignored_0 = "currentConfig: " + this.mCurrentConfiguration + " required: " + whitelistAccessory.getRequiredConfiguration();
        for (WhitelistAccessoryRequirement whitelistAccessoryRequirement : iterator.getRequiredConfiguration()) {
            boolean bl2;
            String string;
            block5: {
                string = whitelistAccessoryRequirement.getName().toLowerCase();
                for (String string2 : d) {
                    if (!string.endsWith(string2)) continue;
                    bl2 = true;
                    break block5;
                }
                bl2 = false;
            }
            if (!bl2) continue;
            string = null;
            for (String string2 : this.mCurrentConfiguration) {
                if (!whitelistAccessoryRequirement.getName().equals(string2.getName())) continue;
                string = string2;
            }
            if (string == null) {
                String cfr_ignored_1 = "missing config: " + whitelistAccessoryRequirement.getName();
                return true;
            }
            String string3 = string.getVersion();
            if (string3.equalsIgnoreCase(whitelistAccessoryRequirement.getVersion())) continue;
            String cfr_ignored_2 = "version mismatch. config=" + whitelistAccessoryRequirement.getName() + " version=" + whitelistAccessoryRequirement.getVersion() + " available=" + (String)string3;
            return true;
        }
        return false;
    }

    public boolean softwareUpdateRequired(WhitelistAccessory whitelistAccessory) {
        Iterator iterator;
        if (whitelistAccessory.getRequiredSoftware() == null) {
            return false;
        }
        String cfr_ignored_0 = "required software: " + whitelistAccessory.getRequiredSoftware();
        for (WhitelistAccessoryRequirement whitelistAccessoryRequirement : iterator.getRequiredSoftware()) {
            String string = whitelistAccessoryRequirement.getName().toLowerCase();
            if (string.contains("mpi-v") && !string.contains("conf")) {
                if (this.mAccessoryDetails.getSoftwareVersion().equalsIgnoreCase(whitelistAccessoryRequirement.getVersion())) continue;
                String cfr_ignored_1 = "current sw version: " + this.mAccessoryDetails.getSoftwareVersion() + " required sw version: " + whitelistAccessoryRequirement.getVersion();
                return true;
            }
            if (!string.contains("kernel")) continue;
            for (ConfigurationItem configurationItem : this.mCurrentConfiguration) {
                if (!string.equals(configurationItem.getName()) || whitelistAccessoryRequirement.getVersion().startsWith(configurationItem.getHash())) continue;
                String cfr_ignored_2 = "current kernel " + string + " version: " + configurationItem.getHash() + " required version: " + whitelistAccessoryRequirement.getVersion();
                return true;
            }
        }
        return false;
    }

    public boolean firmwareUpdateRequired(WhitelistAccessory whitelistAccessory) {
        Iterator iterator;
        if (whitelistAccessory.getRequiredFirmware() == null) {
            return false;
        }
        String cfr_ignored_0 = "required firmware: " + whitelistAccessory.getRequiredFirmware();
        for (WhitelistAccessoryRequirement whitelistAccessoryRequirement : iterator.getRequiredFirmware()) {
            if (!whitelistAccessoryRequirement.getName().toLowerCase().contains("os-v") || this.mAccessoryDetails.getOsVersion().equalsIgnoreCase(whitelistAccessoryRequirement.getVersion())) continue;
            String cfr_ignored_1 = "current os version: " + this.mAccessoryDetails.getOsVersion() + " required os version: " + whitelistAccessoryRequirement.getVersion();
            return true;
        }
        return false;
    }

    public void connectionStateChanged(AccessoryConnectionState newState) {
        String cfr_ignored_0 = "connection state changed. current[" + this.getConnectionState() + "] new[" + newState + "]";
        switch (newState) {
            case CONNECTED: {
                SuccessFailureListener successFailureListener = new SuccessFailureListener(){
                    private /* synthetic */ AccessoryConnectionState a;
                    private /* synthetic */ MiuraPaymentAccessory b;
                    {
                        this.b = miuraPaymentAccessory;
                        this.a = accessoryConnectionState;
                    }

                    public final void onSuccess(Object extraInfo) {
                        this.b.mCommunicationModule.accessorySetupCompleted();
                        this.b.a((MposError)null);
                        MiuraPaymentAccessory.super.connectionStateChanged(this.a);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void onFailure(MposError mposError) {
                        void var1_1;
                        this.b.a((MposError)var1_1);
                    }
                };
                newState = this;
                Log.i((String)"MiuraPaymentAccessory", (String)"setting up device after reconnect");
                newState.systemModule.initialize(new SystemInitializeListener(){
                    private /* synthetic */ SuccessFailureListener a;
                    private /* synthetic */ MiuraPaymentAccessory b;
                    {
                        this.b = miuraPaymentAccessory;
                        this.a = successFailureListener;
                    }

                    public final void success(Accessory accessor) {
                        this.b.a(this.a);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void failure(Accessory accessory, MposError error) {
                        void var2_2;
                        this.a.onFailure((MposError)var2_2);
                    }
                });
                return;
            }
            case DISCONNECTED: {
                this.internal_notifyFullyDisconnected();
                if (this.o != null) {
                    this.a(null, null);
                    return;
                }
                DefaultMposError defaultMposError = new DefaultMposError(ErrorType.ACCESSORY_ERROR, "The accessory was disconnected while trying to connect to it");
                this.a((MposError)defaultMposError);
            }
            case CONNECTED_BUT_UNAVAILABLE: 
            case CONFIGURING_COMMUNICATION_LINK: 
            case UNKNOWN: {
                MiuraPaymentAccessory miuraPaymentAccessory;
                this.a();
                DefaultMposError defaultMposError = miuraPaymentAccessory;
                miuraPaymentAccessory = this;
                super.connectionStateChanged((AccessoryConnectionState)defaultMposError);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnection(SuccessFailureListener listener) {
        void var1_1;
        Log.i((String)"MiuraPaymentAccessory", (String)"connecting to communication module");
        this.n = var1_1;
        Task.callInBackground(() -> {
            try {
                this.mCommunicationModule.connect((CommunicationDelegate)this, new SuccessFailureListener(this){
                    private /* synthetic */ MiuraPaymentAccessory a;
                    {
                        this.a = miuraPaymentAccessory;
                    }

                    public final void onSuccess(Object extraInfo) {
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void onFailure(MposError mposError) {
                        void var1_1;
                        this.a.a((MposError)var1_1);
                    }
                });
            }
            catch (Exception exception) {
                DefaultMposError defaultMposError = new DefaultMposError(exception);
                this.a((MposError)defaultMposError);
            }
            return null;
        });
    }

    /*
     * WARNING - void declaration
     */
    protected void endConnection(SuccessFailureListener listener) {
        void var1_1;
        this.displayModule.cancelDisplayIdleScreenAfterTimeout();
        this.o = var1_1;
        this.mCommunicationModule.disconnect(new SuccessFailureListener(this){
            private /* synthetic */ MiuraPaymentAccessory a;
            {
                this.a = miuraPaymentAccessory;
            }

            /*
             * WARNING - void declaration
             */
            public final void onSuccess(Object extraInfo) {
                void var1_1;
                this.a.a(var1_1, null);
            }

            /*
             * WARNING - void declaration
             */
            public final void onFailure(MposError mposError) {
                void var1_1;
                this.a.a(null, (MposError)var1_1);
            }
        });
    }

    private void a(MposError mposError) {
        if (this.n == null) {
            return;
        }
        SuccessFailureListener successFailureListener = this.n;
        this.n = null;
        if (mposError == null) {
            successFailureListener.onSuccess(null);
            return;
        }
        successFailureListener.onFailure(mposError);
    }

    private void a(Object object, MposError mposError) {
        if (this.o == null) {
            return;
        }
        SuccessFailureListener successFailureListener = this.o;
        this.o = null;
        if (mposError == null) {
            successFailureListener.onSuccess(object);
            return;
        }
        successFailureListener.onFailure(mposError);
    }

    private void a(SuccessFailureListener successFailureListener) {
        this.systemModule.getInformation(new SystemGetInformationListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ MiuraPaymentAccessory b;
            {
                this.b = miuraPaymentAccessory;
                this.a = successFailureListener;
            }

            /*
             * WARNING - void declaration
             */
            public final void success(Accessory accessory, AccessoryDetails accessoryDetails, AccessoryType type) {
                void var2_2;
                this.b.mAccessoryDetails = (AccessoryDetails)var2_2;
                if (!AccessoryType.UNKNOWN.equals((Object)type)) {
                    void var3_3;
                    this.b.mAccessoryType = (AccessoryType)var3_3;
                }
                ((DefaultAccessoryDetails)this.b.mAccessoryDetails).setAccessoryType(this.b.mAccessoryType);
                this.b.updatePaymentAccessoryFeatures();
                this.b.c();
                this.b.d();
                this.b.b(this.a);
            }

            /*
             * WARNING - void declaration
             */
            public final void failure(Accessory accessory, MposError error) {
                void var2_2;
                this.a.onFailure((MposError)var2_2);
            }
        });
    }

    public void updatePaymentAccessoryFeatures() {
        block5: {
            block4: {
                if (this.b().isGreaterThanOrEqualTo(e)) {
                    this.mPaymentAccessoryFeatures.add(PaymentAccessoryFeatures.SCA_ONLINE_PIN_SUPPORT);
                }
                if (this.b().isGreaterThanOrEqualTo(b)) break block4;
                MiuraPaymentAccessory miuraPaymentAccessory = this;
                if (!"1-58ad".equalsIgnoreCase(miuraPaymentAccessory.mAccessoryDetails.getSoftwareVersion())) break block5;
            }
            this.mPaymentAccessoryFeatures.add(PaymentAccessoryFeatures.SCA_SECOND_TAP_WITH_FORCE_CVM_LIMIT_TO_ZERO);
        }
    }

    @NotNull
    private d b() {
        return new d(this.mAccessoryDetails.getSoftwareVersion());
    }

    private void b(SuccessFailureListener successFailureListener) {
        this.securityModule.getEncryptionStatus(new EncryptionGetStatusListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ MiuraPaymentAccessory b;
            {
                this.b = miuraPaymentAccessory;
                this.a = successFailureListener;
            }

            /*
             * WARNING - void declaration
             */
            public final void success(Accessory accessory, EncryptionDetails encryptionDetails) {
                void var2_2;
                this.b.mEncryptionDetails = (EncryptionDetails)var2_2;
                String cfr_ignored_0 = "encryption details generic=" + this.b.mEncryptionDetails.getGenericState() + " sred=" + this.b.mEncryptionDetails.getSredState() + " pin=" + this.b.mEncryptionDetails.getPinState();
                this.b.c(this.a);
            }

            /*
             * WARNING - void declaration
             */
            public final void failure(Accessory accessory, MposError error) {
                void var2_2;
                this.a.onFailure((MposError)var2_2);
            }
        });
    }

    private void c(SuccessFailureListener successFailureListener) {
        this.statusModule.attachToAccessoryStatusUpdates(new AccessoryStatusUpdateListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ MiuraPaymentAccessory b;
            {
                this.b = miuraPaymentAccessory;
                this.a = successFailureListener;
            }

            public final void success(Accessory accessory) {
                this.b.d(this.a);
            }

            /*
             * WARNING - void declaration
             */
            public final void failure(Accessory accessory, MposError error) {
                void var2_2;
                this.a.onFailure((MposError)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final void update(Accessory accessory, AccessoryState state) {
                void var2_2;
                void var1_1;
                BusProvider.getInstance().post((Object)new AccessoryStateChangedBusEvent((Accessory)var1_1, (AccessoryState)var2_2));
            }
        });
    }

    private void d(SuccessFailureListener successFailureListener) {
        this.statusModule.attachToBatteryStatusUpdates(new AccessoryBatteryStatusUpdateListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ MiuraPaymentAccessory b;
            {
                this.b = miuraPaymentAccessory;
                this.a = successFailureListener;
            }

            /*
             * WARNING - void declaration
             */
            public final void success(Accessory accessory, AccessoryBatteryState batteryState, int batteryLevel) {
                void var3_3;
                void var2_2;
                this.b.mAccessoryBatteryState = (AccessoryBatteryState)var2_2;
                this.b.mBatteryLevel = (int)var3_3;
                this.b.e(this.a);
            }

            /*
             * WARNING - void declaration
             */
            public final void failure(Accessory accessory, MposError error) {
                void var2_2;
                this.a.onFailure((MposError)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final void update(Accessory accessory, AccessoryBatteryState batteryState, int batteryLevel) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.b.mAccessoryBatteryState = batteryState;
                this.b.mBatteryLevel = batteryLevel;
                BusProvider.getInstance().post((Object)new AccessoryBatteryStateChangedBusEvent((Accessory)var1_1, (AccessoryBatteryState)var2_2, (int)var3_3));
            }
        });
    }

    private void e(SuccessFailureListener successFailureListener) {
        this.statusModule.attachToCardStatusUpdates(new AccessoryCardStatusUpdateListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ MiuraPaymentAccessory b;
            {
                this.b = miuraPaymentAccessory;
                this.a = successFailureListener;
            }

            /*
             * WARNING - void declaration
             */
            public final void success(Accessory accessory, AccessoryCardEvent event) {
                void var2_2;
                this.b.mCardPresent = var2_2 == AccessoryCardEvent.INSERTED;
                this.b.f(this.a);
            }

            /*
             * WARNING - void declaration
             */
            public final void failure(Accessory accessory, MposError error) {
                void var2_2;
                this.a.onFailure((MposError)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final void update(Accessory accessory, AccessoryCardEvent event) {
                void var2_2;
                void var1_1;
                switch (event) {
                    case UNKNOWN: 
                    case SWIPED: {
                        break;
                    }
                    case INSERTED: {
                        this.b.mCardPresent = true;
                        break;
                    }
                    case REMOVED: {
                        this.b.mCardPresent = false;
                    }
                }
                BusProvider.getInstance().post((Object)new AccessoryCardStateChangedBusEvent((Accessory)var1_1, (AccessoryCardEvent)var2_2));
            }
        });
    }

    private void f(SuccessFailureListener successFailureListener) {
        this.statusModule.attachToKeyPressedUpdates(new AccessoryKeyUpdateListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ MiuraPaymentAccessory b;
            {
                this.b = miuraPaymentAccessory;
                this.a = successFailureListener;
            }

            public final void success(Accessory accessory) {
                this.b.g(this.a);
            }

            /*
             * WARNING - void declaration
             */
            public final void failure(Accessory accessory, MposError error) {
                void var2_2;
                this.a.onFailure((MposError)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final void update(Accessory accessory, AccessoryKeyEvent event) {
                void var2_2;
                void var1_1;
                BusProvider.getInstance().post((Object)new AccessoryKeyPressedBusEvent((Accessory)var1_1, (AccessoryKeyEvent)var2_2));
            }
        });
    }

    private void g(SuccessFailureListener successFailureListener) {
        this.statusModule.attachToInteractionEventsUpdates(new AccessoryInteractionUpdateEventListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ MiuraPaymentAccessory b;
            {
                this.b = miuraPaymentAccessory;
                this.a = successFailureListener;
            }

            public final void success(Accessory accessory) {
                this.b.h(this.a);
            }

            /*
             * WARNING - void declaration
             */
            public final void failure(Accessory accessory, MposError error) {
                void var2_2;
                this.a.onFailure((MposError)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final void update(Accessory accessory, AccessoryInteractionUpdateEvent event, int pinDigits) {
                void var1_1;
                void var3_3;
                void var2_2;
                if (AccessoryInteractionUpdateEvent.PIN_ENTRY_COMPLETED.equals((Object)event) || AccessoryInteractionUpdateEvent.PIN_ENTRY_ERROR.equals((Object)event)) {
                    return;
                }
                WorkflowInteraction workflowInteraction = this.b.getWorkflowInteraction();
                if (workflowInteraction instanceof DefaultTransactionWorkflow) {
                    workflowInteraction = (DefaultTransactionWorkflow)workflowInteraction;
                    if ((workflowInteraction = workflowInteraction.getWorkflowInteraction()) instanceof PaymentChargeRefundWorkflow && (workflowInteraction = (PaymentChargeRefundWorkflow)workflowInteraction).getSelectedInterface() != null && workflowInteraction.getSelectedInterface() == AbstractCardProcessingModule.ActiveInterface.NFC) {
                        workflowInteraction.updateInternalWorkflowState(PaymentWorkflowState.IN_PAYMENT, TransactionState.AWAITING_PIN);
                    }
                }
                workflowInteraction = this.b.a((AccessoryInteractionUpdateEvent)var2_2, (int)var3_3);
                BusProvider.getInstance().post((Object)new AccessoryDisplayedTextUpdateBusEvent(null, DisplayUpdateType.PIN, (DisplayUpdateSupport)new DefaultPINDisplayUpdateSupport((Accessory)var1_1, (PinInformation)workflowInteraction)));
            }
        });
    }

    private PinInformation a(AccessoryInteractionUpdateEvent accessoryInteractionUpdateEvent, int n2) {
        PinInformationStatus pinInformationStatus = null;
        switch (accessoryInteractionUpdateEvent) {
            case UNKNOWN: 
            case PIN_DIGITS_CHANGED: {
                if (!this.p) {
                    this.q = false;
                    pinInformationStatus = PinInformationStatus.STARTED;
                    this.p = true;
                    break;
                }
                pinInformationStatus = PinInformationStatus.UPDATED;
                break;
            }
            case PIN_LAST_TRY: {
                pinInformationStatus = PinInformationStatus.LAST_TRY;
                break;
            }
            case PIN_OK: {
                pinInformationStatus = PinInformationStatus.COMPLETED;
                this.p = false;
                this.q = true;
                break;
            }
            case PIN_INCORRECT: {
                pinInformationStatus = PinInformationStatus.INCORRECT;
                break;
            }
            case PIN_ENTRY_ERROR: 
            case PIN_ENTRY_COMPLETED: {
                this.p = false;
                pinInformationStatus = PinInformationStatus.UPDATED;
            }
        }
        return new DefaultPinInformation(pinInformationStatus, PinInformation.PinType.ANY, n2);
    }

    private void h(SuccessFailureListener successFailureListener) {
        this.displayModule.displayIdleScreen(new DisplayIdleScreenListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ MiuraPaymentAccessory b;
            {
                this.b = miuraPaymentAccessory;
                this.a = successFailureListener;
            }

            public final void success(Accessory accessory) {
                this.a.onSuccess(null);
            }

            /*
             * WARNING - void declaration
             */
            public final void failure(Accessory accessory, MposError error) {
                void var2_2;
                this.a.onFailure((MposError)var2_2);
            }
        });
    }

    public static IccInformation extractIccInformationFromIccData(ArrayList<TlvObject> iccData) {
        String string;
        String string2;
        String string3;
        IccInformation iccInformation = new IccInformation();
        GenericEmvExtractor.extractGenericDataToIccInformation((IccInformation)iccInformation, iccData);
        Object object = TLVHelper.findFirstPrimitiveItemInArray((byte[])bd.a, iccData);
        if (object != null) {
            object = bd.a(object);
            object = object.getValueAsString();
            object = CardHelper.maskAccountNumber((String)object);
            iccInformation.setMaskedAccountNumber((String)object);
        }
        if ((object = TLVHelper.findFirstPrimitiveItemInArray((byte[])bp.a, iccData)) != null) {
            object = bp.a(object);
            object = object.getValueAsString();
            iccInformation.setSredData((String)object);
        }
        if ((object = TLVHelper.findFirstPrimitiveItemInArray((byte[])bq.a, iccData)) != null) {
            object = bq.a(object);
            object = object.getValueAsString();
            iccInformation.setSredKSN((String)object);
            iccInformation.setMacKSN((String)object);
        }
        if ((object = TLVHelper.findFirstPrimitiveItemInArray((byte[])bj.a, iccData)) != null) {
            object = ByteHelper.toHexShortString((byte[])object.getValue());
            iccInformation.setPinData((String)object);
        }
        if ((object = TLVHelper.findFirstPrimitiveItemInArray((byte[])bk.a, iccData)) != null) {
            object = ByteHelper.toHexShortString((byte[])object.getValue());
            iccInformation.setPinKSN((String)object);
        }
        if ((object = TLVHelper.findFirstPrimitiveItemInArray((byte[])bc.a, iccData)) != null) {
            object = ByteHelper.toHexShortString((byte[])object.getValue());
            iccInformation.setMacData((String)object);
        }
        if ((object = TLVHelper.findFirstPrimitiveItemInArray((byte[])bf.a, iccData)) != null) {
            object = bf.a(object);
            object = object.getValueAsString();
            string3 = CardHelper.parseAccountNumberFromTrack2((String)object);
            string2 = CardHelper.maskAccountNumber((String)string3);
            iccInformation.setMaskedAccountNumber(string2);
            iccInformation.setMaskedTrack2(CardHelper.maskTrack2Data((String)object));
            string2 = CardHelper.parseExpiryDateFromTrack2((String)object);
            iccInformation.setExpirationDate(string2);
        }
        if ((object = TLVHelper.findFirstPrimitiveItemInArray((byte[])be.a, string)) != null) {
            object = be.a(object);
            string3 = object.getValueAsString();
            string2 = CardHelper.parseAccountNumberFromTrack2((String)string3);
            string2 = CardHelper.maskAccountNumber((String)string2);
            if (iccInformation.getMaskedAccountNumber() == null) {
                iccInformation.setMaskedAccountNumber(string2);
            }
            if (iccInformation.getMaskedTrack2() == null) {
                iccInformation.setMaskedTrack2(CardHelper.maskTrack2Data((String)string3));
            }
            if (iccInformation.getRawMaskedTrack2Equivalent() == null) {
                iccInformation.setRawMaskedTrack2Equivalent(object.getValue());
            }
            string = CardHelper.parseExpiryDateFromTrack2((String)string3);
            if (iccInformation.getExpirationDate() == null) {
                iccInformation.setExpirationDate(string);
            }
        }
        return iccInformation;
    }

    public PaymentDetailsCustomerVerificationDetailed extractNfcCustomerVerificationDetailedFromIccData(ArrayList<TlvObject> iccData) {
        Object object;
        if ((object = TLVHelper.findFirstPrimitiveItemInArray((byte[])aT.a, (List)object)) == null) {
            if (this.q) {
                return PaymentDetailsCustomerVerificationDetailed.PIN_OFFLINE_ENCIPHERED_AND_SIGNATURE;
            }
            return PaymentDetailsCustomerVerificationDetailed.SIGNATURE;
        }
        if ((object = aT.a((PrimitiveTlv)object)) == null) {
            if (this.q) {
                return PaymentDetailsCustomerVerificationDetailed.PIN_OFFLINE_ENCIPHERED_AND_SIGNATURE;
            }
            return PaymentDetailsCustomerVerificationDetailed.SIGNATURE;
        }
        Object object2 = object;
        object = this;
        byte[] byArray = object2.getValue();
        object2 = byArray;
        switch (5.d[(byArray == null || ((PrimitiveTlv)object2).length != 1 ? aT.a.g : aT.a.a((byte)object2[0])).ordinal()]) {
            case 1: 
            case 2: {
                return PaymentDetailsCustomerVerificationDetailed.NONE;
            }
            case 3: {
                if (((MiuraPaymentAccessory)((Object)object)).b().isGreaterThanOrEqualTo(f)) {
                    return PaymentDetailsCustomerVerificationDetailed.NONE;
                }
                return PaymentDetailsCustomerVerificationDetailed.SIGNATURE;
            }
            case 4: {
                return PaymentDetailsCustomerVerificationDetailed.PIN_OFFLINE_ENCIPHERED;
            }
            case 5: {
                return PaymentDetailsCustomerVerificationDetailed.PIN_OFFLINE_PLAINTEXT;
            }
            case 6: {
                return PaymentDetailsCustomerVerificationDetailed.PIN_ONLINE;
            }
            case 7: {
                return PaymentDetailsCustomerVerificationDetailed.CUSTOMER_DEVICE;
            }
        }
        return PaymentDetailsCustomerVerificationDetailed.UNKNOWN;
    }

    /*
     * WARNING - void declaration
     */
    public void setAccessoryDetails(DefaultAccessoryDetails details) {
        void var1_1;
        this.mAccessoryDetails = var1_1;
    }

    private void c() {
        if (this.b().isLowerThan(a)) {
            String cfr_ignored_0 = "NFC not eligible, current MPI version= " + this.mAccessoryDetails.getSoftwareVersion() + " required=" + a;
            return;
        }
        String cfr_ignored_1 = "NFC eligible, current MPI version= " + this.mAccessoryDetails.getSoftwareVersion() + " required=" + a;
        if (this.mAccessoryType == AccessoryType.MIURA_M007 || this.mAccessoryType == AccessoryType.MIURA_M010) {
            this.mPaymentAccessoryFeatures.add(PaymentAccessoryFeatures.NFC);
        }
        if (this.mAccessoryType == AccessoryType.MIURA_M010) {
            this.mPaymentAccessoryRequirements.add(PaymentAccessoryRequirement.MANUAL_NFC_ACTIVATION);
            this.mPaymentAccessoryRequirements.add(PaymentAccessoryRequirement.CONTACTLESS_ONLY_WORKAROUND);
        }
    }

    private void d() {
        this.mPaymentAccessoryRequirements.add(PaymentAccessoryRequirement.MOTO_ABORT_SKIPS_ENTRY);
    }

    public boolean supportsUTF8() {
        boolean bl2 = this.b().isGreaterThanOrEqualTo(c);
        String cfr_ignored_0 = "UTF8 support=" + bl2 + " MPI version=" + this.mAccessoryDetails.getSoftwareVersion();
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    public AccessoryComponent getAccessoryComponent(AccessoryComponentType componentType) {
        void var1_1;
        switch (5.e[var1_1.ordinal()]) {
            case 1: {
                return null;
            }
            case 2: {
                return this.j;
            }
            case 3: {
                return this.k;
            }
            case 4: {
                return this.l;
            }
            case 5: {
                return this.m;
            }
        }
        return null;
    }

    public void resetGlobalStateBeforeTransaction() {
        this.p = false;
        this.q = false;
        this.mCardPresent = false;
        this.mShowIdleScreenTimerAfterCardRemoval = false;
    }
}

