/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.accessories.vipa;

import bolts.Task;
import io.mpos.accessories.Accessory;
import io.mpos.accessories.AccessoryConnectionState;
import io.mpos.accessories.AccessoryDetails;
import io.mpos.accessories.AccessoryFamily;
import io.mpos.accessories.AccessoryType;
import io.mpos.accessories.components.AccessoryComponent;
import io.mpos.accessories.components.AccessoryComponentType;
import io.mpos.accessories.events.AccessoryCardEvent;
import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.accessories.payment.PaymentAccessoryFeatures;
import io.mpos.accessories.vipa.a;
import io.mpos.accessories.vipa.b;
import io.mpos.accessories.vipa.c;
import io.mpos.accessories.vipa.modules.VipaCardProcessingModule;
import io.mpos.accessories.vipa.modules.VipaDisplayModule;
import io.mpos.accessories.vipa.modules.VipaInteractionModule;
import io.mpos.accessories.vipa.modules.VipaLogModule;
import io.mpos.accessories.vipa.modules.VipaSecurityModule;
import io.mpos.accessories.vipa.modules.VipaStatusModule;
import io.mpos.accessories.vipa.modules.VipaSystemModule;
import io.mpos.accessories.vipa.obfuscated.C;
import io.mpos.accessories.vipa.obfuscated.E;
import io.mpos.accessories.vipa.obfuscated.ac;
import io.mpos.accessories.vipa.obfuscated.ah;
import io.mpos.accessories.vipa.obfuscated.at;
import io.mpos.accessories.vipa.obfuscated.au;
import io.mpos.accessories.vipa.obfuscated.ax;
import io.mpos.accessories.vipa.obfuscated.bC;
import io.mpos.accessories.vipa.obfuscated.bM;
import io.mpos.accessories.vipa.obfuscated.cK;
import io.mpos.accessories.vipa.obfuscated.cX;
import io.mpos.accessories.vipa.obfuscated.cY;
import io.mpos.accessories.vipa.obfuscated.d;
import io.mpos.accessories.vipa.obfuscated.e;
import io.mpos.accessories.vipa.obfuscated.g;
import io.mpos.accessories.vipa.obfuscated.h;
import io.mpos.accessories.vipa.obfuscated.i;
import io.mpos.accessories.vipa.obfuscated.l;
import io.mpos.accessories.vipa.obfuscated.q;
import io.mpos.accessories.vipa.util.TerminalFeature;
import io.mpos.accessories.vipa.util.TerminalFeatures;
import io.mpos.accessories.vipa.util.m;
import io.mpos.accessories.vipa.util.n;
import io.mpos.accessories.vipa.util.p;
import io.mpos.accessories.vipa.util.t;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.shared.accessories.DefaultAccessoryDetails;
import io.mpos.shared.accessories.EncryptionDetails;
import io.mpos.shared.accessories.EncryptionDetailsState;
import io.mpos.shared.accessories.EncryptionKeyInjectionStrategy;
import io.mpos.shared.accessories.PaymentAccessoryRequirement;
import io.mpos.shared.accessories.events.AccessoryInteractionUpdateEvent;
import io.mpos.shared.accessories.modules.DisplayHtmlData;
import io.mpos.shared.accessories.modules.listener.AccessoryCardStatusUpdateListener;
import io.mpos.shared.accessories.modules.listener.AccessoryInteractionUpdateEventListener;
import io.mpos.shared.accessories.modules.listener.DisplayIdleScreenListener;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListener;
import io.mpos.shared.accessories.modules.listener.LanguageSwitchListener;
import io.mpos.shared.accessories.modules.listener.SystemGetInformationListener;
import io.mpos.shared.accessories.modules.listener.SystemInitializeListener;
import io.mpos.shared.accessories.mpivipa.MpiVipaChainedMessageReader;
import io.mpos.shared.accessories.payment.AbstractPaymentAccessory;
import io.mpos.shared.communicationmodules.CommunicationDelegate;
import io.mpos.shared.communicationmodules.CommunicationModule;
import io.mpos.shared.communicationmodules.SuccessFailureListener;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.events.BusProvider;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.provider.WhitelistAccessory;
import io.mpos.shared.provider.WhitelistAccessoryRequirement;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.helper.IsoBlockFrameReader;
import io.mpos.specs.helper.TagLogHelper;
import io.mpos.specs.iso7816.IsoBlockFrame;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kotlin.jvm.functions.Function3;

public class VipaPaymentAccessory
extends AbstractPaymentAccessory
implements a {
    private final IsoBlockFrameReader a = new IsoBlockFrameReader();
    private final MpiVipaChainedMessageReader b = new MpiVipaChainedMessageReader();
    private final b c = new b(new at(new bM()));
    private final c d = new c(this, new ax());
    private final io.mpos.accessories.vipa.util.q e = new io.mpos.accessories.vipa.util.q(this.c, new au(this.d));
    private final ac f = new ac(this, BusProvider.getInstance());
    private final t g = new t();
    private final io.mpos.accessories.vipa.obfuscated.c h = new io.mpos.accessories.vipa.obfuscated.c(this.d, this.c, Task.BACKGROUND_EXECUTOR);
    private final d i = new d(this.d, this.c);
    private final e j = new e(this.i);
    private final h k;
    private SuccessFailureListener l;
    private SuccessFailureListener m;
    private static final p n = new p("6.6.1.3");
    private static final p o = new p("6.6.1.16");
    private static final p p = new p("6.6.1.16");
    private i q;
    private TerminalFeatures r;

    public VipaPaymentAccessory(CommunicationModule communicationModule) {
        super(communicationModule);
        this.mAccessoryFamily = AccessoryFamily.VERIFONE_VIPA;
        this.mAccessoryDetails = new DefaultAccessoryDetails(null, null, null, null);
        this.mPaymentAccessoryRequirements = EnumSet.of(PaymentAccessoryRequirement.NO_NFC_START_DISPLAY);
        this.mPaymentAccessoryFeatures = EnumSet.of(PaymentAccessoryFeatures.MAGNETIC_STRIPE, new PaymentAccessoryFeatures[]{PaymentAccessoryFeatures.ICC, PaymentAccessoryFeatures.NFC, PaymentAccessoryFeatures.EMV_KERNEL, PaymentAccessoryFeatures.SRED_ENCRYPTION, PaymentAccessoryFeatures.KEYPAD, PaymentAccessoryFeatures.DISPLAY, PaymentAccessoryFeatures.ONLINE_TRANSACTIONS, PaymentAccessoryFeatures.OFFLINE_PIN, PaymentAccessoryFeatures.REFUND, PaymentAccessoryFeatures.SCA_ONLINE_PIN_SUPPORT});
        this.mEncryptionKeyInjectionStrategy = EncryptionKeyInjectionStrategy.KEY_LOADING;
        VipaPaymentAccessory vipaPaymentAccessory = this;
        this.systemModule = new VipaSystemModule((PaymentAccessory)vipaPaymentAccessory, vipaPaymentAccessory.c, this.d);
        VipaPaymentAccessory vipaPaymentAccessory2 = this;
        this.displayModule = new VipaDisplayModule((PaymentAccessory)vipaPaymentAccessory2, vipaPaymentAccessory2.c, this.d);
        VipaPaymentAccessory vipaPaymentAccessory3 = this;
        this.cardProcessingModule = new VipaCardProcessingModule(vipaPaymentAccessory3, vipaPaymentAccessory3.c, this.d);
        VipaPaymentAccessory vipaPaymentAccessory4 = this;
        this.securityModule = new VipaSecurityModule(vipaPaymentAccessory4, vipaPaymentAccessory4.c, this.d);
        VipaPaymentAccessory vipaPaymentAccessory5 = this;
        this.interactionModule = new VipaInteractionModule(vipaPaymentAccessory5, vipaPaymentAccessory5.c, this.d);
        VipaPaymentAccessory vipaPaymentAccessory6 = this;
        this.statusModule = new VipaStatusModule((PaymentAccessory)vipaPaymentAccessory6, vipaPaymentAccessory6.c, this.d);
        VipaPaymentAccessory vipaPaymentAccessory7 = this;
        this.logModule = new VipaLogModule((PaymentAccessory)vipaPaymentAccessory7, vipaPaymentAccessory7.c, this.d);
        g g2 = new g(this.c, (Function3<? super String, ? super Map<String, String>, ? super l, C>)((Function3)(string, map, l2) -> new C((String)string, (Map<String, String>)map, this.d, (l)l2)));
        n n2 = new n(this.d, this.c, this.displayModule);
        this.k = new h(g2, this.displayModule, n2);
        EncryptionDetailsState encryptionDetailsState = EncryptionDetailsState.NOT_INITIALIZED;
        this.mEncryptionDetails = new EncryptionDetails(encryptionDetailsState, encryptionDetailsState, EncryptionDetailsState.NOT_AVAILABLE);
        this.mTypeProvidedByAccessory = true;
    }

    public void resetModules() {
        this.c.b();
    }

    public boolean configurationUpdateRequired(WhitelistAccessory whitelistAccessory) {
        if (whitelistAccessory.getRequiredConfiguration() == null) {
            return false;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        boolean[] blArray = new boolean[1];
        this.e.a(whitelistAccessory.getRequiredConfiguration(), new SuccessFailureListener(){
            private /* synthetic */ boolean[] a;
            private /* synthetic */ CountDownLatch b;
            private /* synthetic */ VipaPaymentAccessory c;
            {
                this.c = vipaPaymentAccessory;
                this.a = blArray;
                this.b = countDownLatch;
            }

            public final void onSuccess(Object extraInfo) {
                this.a[0] = false;
                this.b.countDown();
            }

            public final void onFailure(MposError mposError) {
                this.a[0] = true;
                this.b.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        return blArray[0];
    }

    public boolean softwareUpdateRequired(WhitelistAccessory whitelistAccessory) {
        return this.g.a(this.mAccessoryDetails, (List<WhitelistAccessoryRequirement>)whitelistAccessory.getRequiredSoftware());
    }

    public boolean firmwareUpdateRequired(WhitelistAccessory whitelistAccessory) {
        return this.g.b(this.mAccessoryDetails, whitelistAccessory.getRequiredFirmware());
    }

    protected void startConnection(SuccessFailureListener listener) {
        this.l = listener;
        this.mCommunicationModule.connect((CommunicationDelegate)this, new SuccessFailureListener(this){
            private /* synthetic */ VipaPaymentAccessory a;
            {
                this.a = vipaPaymentAccessory;
            }

            public final void onSuccess(Object extraInfo) {
            }

            public final void onFailure(MposError mposError) {
                this.a.a(null, mposError);
            }
        });
    }

    protected void endConnection(SuccessFailureListener listener) {
        this.m = listener;
        this.displayModule.cancelDisplayIdleScreenAfterTimeout();
        this.mCommunicationModule.disconnect(new SuccessFailureListener(this){
            private /* synthetic */ VipaPaymentAccessory a;
            {
                this.a = vipaPaymentAccessory;
            }

            public final void onSuccess(Object extraInfo) {
                this.a.b(extraInfo, null);
            }

            public final void onFailure(MposError mposError) {
                this.a.b(null, mposError);
            }
        });
    }

    public void connectionStateChanged(AccessoryConnectionState newState) {
        switch (newState) {
            case CONNECTED: {
                SuccessFailureListener successFailureListener = new SuccessFailureListener(){
                    private /* synthetic */ AccessoryConnectionState a;
                    private /* synthetic */ VipaPaymentAccessory b;
                    {
                        this.b = vipaPaymentAccessory;
                        this.a = accessoryConnectionState;
                    }

                    public final void onSuccess(Object extraInfo) {
                        this.b.mCommunicationModule.accessorySetupCompleted();
                        VipaPaymentAccessory.super.connectionStateChanged(this.a);
                        this.b.a(extraInfo, null);
                    }

                    public final void onFailure(MposError mposError) {
                        this.b.a(null, mposError);
                    }
                };
                VipaPaymentAccessory vipaPaymentAccessory = this;
                Log.i((String)"VipaPaymentAccessory", (String)"setting up device after reconnect");
                SuccessFailureListener successFailureListener2 = successFailureListener;
                VipaPaymentAccessory vipaPaymentAccessory2 = vipaPaymentAccessory;
                vipaPaymentAccessory2.systemModule.getInformation(new SystemGetInformationListener(){
                    private /* synthetic */ SuccessFailureListener a;
                    private /* synthetic */ VipaPaymentAccessory b;
                    {
                        this.b = vipaPaymentAccessory;
                        this.a = successFailureListener;
                    }

                    public final void success(Accessory accessory, AccessoryDetails accessoryDetails, AccessoryType type) {
                        this.b.setAccessoryDetails(accessoryDetails);
                        if (!AccessoryType.UNKNOWN.equals((Object)type)) {
                            this.b.mAccessoryType = type;
                        }
                        this.b.updatePaymentAccessoryFeatures();
                        ((DefaultAccessoryDetails)this.b.mAccessoryDetails).setAccessoryType(this.b.mAccessoryType);
                        this.b.a(this.a);
                    }

                    public final void failure(Accessory accessory, MposError error) {
                        this.a.onFailure(error);
                    }
                });
                return;
            }
            case DISCONNECTED: {
                this.internal_notifyFullyDisconnected();
                if (this.m != null) {
                    this.b(null, null);
                    return;
                }
                DefaultMposError defaultMposError = new DefaultMposError(ErrorType.ACCESSORY_ERROR, "The accessory was disconnected while trying to connect to it");
                this.a(null, (MposError)defaultMposError);
            }
            case CONNECTED_BUT_UNAVAILABLE: 
            case CONFIGURING_COMMUNICATION_LINK: 
            case UNKNOWN: {
                this.c.a();
                AccessoryConnectionState accessoryConnectionState = newState;
                VipaPaymentAccessory vipaPaymentAccessory = this;
                super.connectionStateChanged(accessoryConnectionState);
            }
        }
    }

    public i getCardAppConfiguration() {
        return this.q;
    }

    private void a(Object object, MposError mposError) {
        if (this.l == null) {
            return;
        }
        SuccessFailureListener successFailureListener = this.l;
        this.l = null;
        if (mposError == null) {
            successFailureListener.onSuccess(object);
            return;
        }
        successFailureListener.onFailure(mposError);
    }

    private void b(Object object, MposError mposError) {
        if (this.m == null) {
            return;
        }
        SuccessFailureListener successFailureListener = this.m;
        this.m = null;
        if (mposError == null) {
            this.h.a();
            successFailureListener.onSuccess(object);
            return;
        }
        successFailureListener.onFailure(mposError);
    }

    protected void handleQueuedData() {
        byte[] byArray = this.getCurrentQueuedData();
        try {
            this.a.process(byArray);
        }
        catch (Exception exception) {
            Log.e((String)"VipaPaymentAccessory", (String)"FrameReader can't process data", (Throwable)exception);
        }
        while (this.a.hasCompleteFrame()) {
            IsoBlockFrame isoBlockFrame = this.a.getNextFrame();
            IsoBlockFrame isoBlockFrame2 = null;
            try {
                isoBlockFrame2 = this.b.process(isoBlockFrame);
            }
            catch (Exception exception) {
                Log.e((String)"VipaPaymentAccessory", (String)"FrameReader can't process frame", (Throwable)exception);
            }
            if (isoBlockFrame2 == null) continue;
            bC bC2 = bC.a(isoBlockFrame2);
            String cfr_ignored_0 = "got VIPA response: " + bC2;
            bC2.serialize();
            TagLogHelper.logFullTlv((String)"VipaPaymentAccessory", (TlvObject)bC2.a());
            this.c.a(bC2);
        }
    }

    public AccessoryComponent getAccessoryComponent(AccessoryComponentType componentType) {
        switch (componentType) {
            case BARCODE_SCANNER: {
                return this.h;
            }
            case INTERACTION: {
                return this.i;
            }
            case MOTO: {
                return this.j;
            }
            case TIPPING: {
                boolean bl2 = this.isTerminalFeatureEnabled(TerminalFeature.UI_CHANGES_Q3_2021);
                boolean bl3 = this.mAccessoryType == AccessoryType.VERIFONE_P400_VIPA;
                if (bl3 && bl2) {
                    return this.k;
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void setCardPresent(boolean present) {
        this.mCardPresent = present;
    }

    public void setAccessoryDetails(AccessoryDetails accessoryDetails) {
        this.mAccessoryDetails = accessoryDetails;
    }

    public void updatePaymentAccessoryFeatures() {
        String string;
        p p2;
        Object object = this.mAccessoryType;
        if (!(switch (object) {
            case AccessoryType.VERIFONE_P400_VIPA, AccessoryType.VERIFONE_VX820_VIPA -> false;
            default -> true;
        })) {
            Log.i((String)"VipaPaymentAccessory", (String)"device has no built in battery");
            this.mPaymentAccessoryFeatures.add(PaymentAccessoryFeatures.NO_BATTERY);
        }
        if ((p2 = new p((String)(object = (string = this.mAccessoryDetails.getSoftwareVersion())))).isGreaterThanOrEqualTo(n)) {
            this.mPaymentAccessoryFeatures.add(PaymentAccessoryFeatures.YELLOW_KEY_ON_NFC);
        }
        if ((p2 = new p((String)(object = string))).isGreaterThanOrEqualTo(o)) {
            this.mPaymentAccessoryFeatures.add(PaymentAccessoryFeatures.SCA_SECOND_TAP_WITH_FORCE_CVM_LIMIT_TO_ZERO);
        }
    }

    public boolean hasBattery() {
        return !this.mPaymentAccessoryFeatures.contains(PaymentAccessoryFeatures.NO_BATTERY);
    }

    public boolean isFastFileDownloadAvailable() {
        p p2 = new p(this.mAccessoryDetails.getSoftwareVersion());
        return p2.isGreaterThanOrEqualTo(p);
    }

    public boolean isTerminalFeatureEnabled(TerminalFeature terminalFeature) {
        return this.r != null && this.r.isEnabled(terminalFeature);
    }

    private void a(SuccessFailureListener successFailureListener) {
        cY cY2 = new cY(new au(this.d), this.c);
        cY2.a("I:1/cardapp.cfg", this.isFastFileDownloadAvailable(), new cX<byte[]>(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ VipaPaymentAccessory b;
            {
                this.b = vipaPaymentAccessory;
                this.a = successFailureListener;
            }

            @Override
            public final void a(MposError mposError) {
                Log.e((String)"VipaPaymentAccessory", (String)"Failed to download cardapp.cfg, continuing with empty VipaCardAppConfiguration object.");
                this.b.setEmptyConfiguration();
                this.b.b(this.a);
            }

            @Override
            public final /* synthetic */ void a(Object object) {
                byte[] byArray = (byte[])object;
                11 var2_3 = this;
                this.b.q = new i(byArray);
                var2_3.b.b(var2_3.a);
            }
        });
    }

    public void setEmptyConfiguration() {
        this.q = new i();
    }

    private void b(SuccessFailureListener successFailureListener) {
        LanguageSwitchListener languageSwitchListener = new LanguageSwitchListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ VipaPaymentAccessory b;
            {
                this.b = vipaPaymentAccessory;
                this.a = successFailureListener;
            }

            public final /* synthetic */ void onOperationSuccess(Object object, Object object2) {
                Accessory cfr_ignored_0 = (Accessory)object;
                Locale cfr_ignored_1 = (Locale)object2;
                12 var3_3 = this;
                var3_3.b.c(var3_3.a);
            }

            public final /* synthetic */ void onOperationFailure(Object object, MposError mposError) {
                Accessory cfr_ignored_0 = (Accessory)object;
                12 var3_3 = this;
                var3_3.b.c(var3_3.a);
            }
        };
        VipaPaymentAccessory vipaPaymentAccessory = this;
        Locale locale = vipaPaymentAccessory.isLanguageSwitchSupported(vipaPaymentAccessory.getLocale()) ? vipaPaymentAccessory.getLocale() : Locale.ENGLISH;
        vipaPaymentAccessory.getDisplayModule().setTerminalLanguage(locale, languageSwitchListener);
    }

    private void c(SuccessFailureListener successFailureListener) {
        cY cY2 = new cY(new au(this.d), this.c);
        cY2.a("I:1/features.json", this.isFastFileDownloadAvailable(), new cX<byte[]>(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ VipaPaymentAccessory b;
            {
                this.b = vipaPaymentAccessory;
                this.a = successFailureListener;
            }

            @Override
            public final void a(MposError mposError) {
                Log.w((String)"VipaPaymentAccessory", (String)"Failed to download I:1/features.json, continuing with disabled terminal features.");
                this.b.r = new TerminalFeatures();
                this.b.mProfiler.event(Profiler.Category.ACCESSORY_ERROR, "error loading terminal features file");
                this.b.d(this.a);
            }

            @Override
            public final /* synthetic */ void a(Object object) {
                byte[] byArray = (byte[])object;
                13 var2_3 = this;
                this.b.r = io.mpos.accessories.vipa.util.m.a(TerminalFeatures.Companion, byArray);
                if (!var2_3.b.r.isEnabled(TerminalFeature.UI_CHANGES_Q3_2021)) {
                    var2_3.b.mProfiler.event(Profiler.Category.ACCESSORY_ERROR, "terminal feature UI_CHANGES_Q3_2021 is not enabled");
                }
                var2_3.b.d(var2_3.a);
            }
        });
    }

    private void d(SuccessFailureListener successFailureListener) {
        this.systemModule.initialize(new SystemInitializeListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ VipaPaymentAccessory b;
            {
                this.b = vipaPaymentAccessory;
                this.a = successFailureListener;
            }

            public final void success(Accessory accessory) {
                this.b.mEncryptionDetails.setSredState(EncryptionDetailsState.READY);
                this.b.mEncryptionDetails.setPinState(EncryptionDetailsState.READY);
                this.b.e(this.a);
            }

            public final void failure(Accessory accessory, MposError error) {
                if (error.getErrorType() == ErrorType.ACCESSORY_REQUIRES_UPDATE) {
                    this.b.e(this.a);
                    return;
                }
                this.a.onFailure(error);
            }
        });
    }

    private void e(SuccessFailureListener successFailureListener) {
        this.statusModule.attachToCardStatusUpdates(new AccessoryCardStatusUpdateListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ VipaPaymentAccessory b;
            {
                this.b = vipaPaymentAccessory;
                this.a = successFailureListener;
            }

            public final void success(Accessory accessor, AccessoryCardEvent event) {
                this.b.f(this.a);
            }

            public final void failure(Accessory accessory, MposError error) {
                this.a.onFailure(error);
            }

            public final void update(Accessory accessory, AccessoryCardEvent event) {
                this.a.onFailure((MposError)new DefaultMposError(ErrorType.INTERNAL_INCONSISTENCY));
            }
        });
    }

    private void f(SuccessFailureListener successFailureListener) {
        this.statusModule.attachToInteractionEventsUpdates(new AccessoryInteractionUpdateEventListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ VipaPaymentAccessory b;
            {
                this.b = vipaPaymentAccessory;
                this.a = successFailureListener;
            }

            public final void success(Accessory accessor) {
                this.b.g(this.a);
            }

            public final void failure(Accessory accessory, MposError error) {
                this.a.onFailure(error);
            }

            public final void update(Accessory accessory, AccessoryInteractionUpdateEvent event, int pinDigits) {
                if (event == AccessoryInteractionUpdateEvent.APP_SELECTION_SCREEN) {
                    this.b.f.a();
                    return;
                }
                this.b.f.a(event, pinDigits);
            }
        });
    }

    private void g(SuccessFailureListener successFailureListener) {
        E e2 = new E(this.d, "I:15/www/display_text.html", new ah<String>(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ VipaPaymentAccessory b;
            {
                this.b = vipaPaymentAccessory;
                this.a = successFailureListener;
            }

            @Override
            public final void a(q q2, MposError mposError) {
                this.b.c.c(q2);
                this.b.h(this.a);
            }

            @Override
            public final /* synthetic */ void a(q q2, Object object) {
                String cfr_ignored_0 = (String)object;
                q q3 = q2;
                4 var3_4 = this;
                var3_4.b.c.c(q3);
                var3_4.b.mPaymentAccessoryFeatures.add(PaymentAccessoryFeatures.STYLED_SCREENS);
                var3_4.b.h(var3_4.a);
            }
        });
        this.c.b(e2);
    }

    private void h(SuccessFailureListener successFailureListener) {
        this.displayModule.displayIdleScreen(new DisplayIdleScreenListener(){
            private /* synthetic */ SuccessFailureListener a;
            private /* synthetic */ VipaPaymentAccessory b;
            {
                this.b = vipaPaymentAccessory;
                this.a = successFailureListener;
            }

            public final void success(Accessory accessory) {
                this.a.onSuccess(null);
            }

            public final void failure(Accessory accessory, MposError error) {
                this.a.onFailure(error);
            }
        });
    }

    public void displayText(DisplayHtmlData text, GenericOperationSuccessFailureListener<Accessory, String[]> listener) {
        this.displayModule.displayText(text, listener);
    }

    public boolean isLanguageSwitchSupported(Locale locale) {
        for (Locale locale2 : this.getCardAppConfiguration().d()) {
            if (!locale2.getLanguage().equals(locale.getLanguage())) continue;
            return true;
        }
        return false;
    }

    public List<byte[]> nativelySupportedStrongCustomerAuthenticationARCs() {
        return Arrays.asList("70".getBytes(), "1A".getBytes());
    }

    public cK.a getRefundType() {
        VipaPaymentAccessory vipaPaymentAccessory = this;
        cK.a a2 = vipaPaymentAccessory.getCardAppConfiguration().c() ? cK.a.b : cK.a.a;
        return a2;
    }
}

